/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.impl;

import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.streams.WriteStream;
import io.vertx.resourceadapter.VertxEventBus;
import java.util.logging.Logger;

public class WrappedEventBus
implements VertxEventBus {
    private static Logger log = Logger.getLogger(WrappedEventBus.class.getName());
    private final EventBus delegate;

    public WrappedEventBus(EventBus bus) {
        if (bus == null) {
            throw new IllegalArgumentException("EventBus can't be null.");
        }
        this.delegate = bus;
    }

    public VertxEventBus send(String address, Object message) {
        this.delegate.send(address, message);
        return this;
    }

    public VertxEventBus send(String address, Object message, DeliveryOptions options) {
        this.delegate.send(address, message, options);
        return this;
    }

    public VertxEventBus publish(String address, Object message) {
        this.delegate.publish(address, message);
        return this;
    }

    public VertxEventBus publish(String address, Object message, DeliveryOptions options) {
        this.delegate.publish(address, message, options);
        return this;
    }

    public <T> WriteStream<T> sender(String address) {
        return this.delegate.sender(address);
    }

    public <T> WriteStream<T> sender(String address, DeliveryOptions options) {
        return this.delegate.sender(address, options);
    }

    public <T> WriteStream<T> publisher(String address) {
        return this.delegate.publisher(address);
    }

    public <T> WriteStream<T> publisher(String address, DeliveryOptions options) {
        return this.delegate.publisher(address, options);
    }
}

