/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.internal;

import java.io.IOException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.swagger.SwaggerArchive;
import org.wildfly.swarm.swagger.internal.SwaggerConfigurationAsset;

public class SwaggerArchiveImpl
extends AssignableBase<ArchiveBase<?>>
implements SwaggerArchive {
    public static final String SERVICE_ACTIVATOR_CLASS_NAME = "org.wildfly.swarm.swagger.deployment.SwaggerServiceActivator";
    private SwaggerConfigurationAsset configurationAsset;

    public SwaggerArchiveImpl(ArchiveBase<?> archive) throws IOException {
        super(archive);
        if (!((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).containsServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME)) {
            ((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).addServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME);
            ((JARArchive)this.as(JARArchive.class)).addModule("org.wildfly.swarm.swagger", "deployment");
        }
        this.loadOrCreateConfigurationAsset();
    }

    public SwaggerConfigurationAsset getConfigurationAsset() {
        return this.configurationAsset;
    }

    @Override
    public SwaggerArchive setResourcePackages(String ... packages) {
        this.getConfigurationAsset().register(packages);
        return this;
    }

    @Override
    public SwaggerArchive setTitle(String title) {
        this.getConfigurationAsset().setTitle(title);
        return this;
    }

    @Override
    public SwaggerArchive setDescription(String description) {
        this.getConfigurationAsset().setDescription(description);
        return this;
    }

    @Override
    public SwaggerArchive setTermsOfServiceUrl(String url) {
        this.getConfigurationAsset().setTermsOfServiceUrl(url);
        return this;
    }

    @Override
    public SwaggerArchive setContact(String contact) {
        this.getConfigurationAsset().setContact(contact);
        return this;
    }

    @Override
    public SwaggerArchive setLicense(String license) {
        this.getConfigurationAsset().setLicense(license);
        return this;
    }

    @Override
    public SwaggerArchive setLicenseUrl(String licenseUrl) {
        this.getConfigurationAsset().setLicenseUrl(licenseUrl);
        return this;
    }

    @Override
    public SwaggerArchive setVersion(String version) {
        this.getConfigurationAsset().setVersion(version);
        return this;
    }

    @Override
    public SwaggerArchive setSchemes(String ... schemes) {
        this.getConfigurationAsset().setSchemes(schemes);
        return this;
    }

    @Override
    public SwaggerArchive setHost(String host) {
        this.getConfigurationAsset().setHost(host);
        return this;
    }

    @Override
    public SwaggerArchive setContextRoot(String root) {
        this.getConfigurationAsset().setContextRoot(root);
        return this;
    }

    @Override
    public boolean hasContextRoot() {
        return this.getConfigurationAsset().getContextRoot() != null;
    }

    @Override
    public SwaggerArchive setPrettyPrint(boolean prettyPrint) {
        this.getConfigurationAsset().setPrettyPrint(prettyPrint);
        return this;
    }

    @Override
    public boolean hasResourcePackages() {
        return this.getConfigurationAsset().getResourcePackages() != null;
    }

    @Override
    public String[] getResourcePackages() {
        return this.getConfigurationAsset().getResourcePackages();
    }

    private void loadOrCreateConfigurationAsset() throws IOException {
        Node node = ((ArchiveBase)this.getArchive()).get("META-INF/swarm.swagger.conf");
        if (node == null && ((ArchiveBase)this.getArchive()).getName().endsWith(".war")) {
            node = ((ArchiveBase)this.getArchive()).get("WEB-INF/classes/META-INF/swarm.swagger.conf");
        }
        if (node != null) {
            Asset asset = node.getAsset();
            if (asset instanceof SwaggerConfigurationAsset) {
                this.configurationAsset = (SwaggerConfigurationAsset)asset;
            } else {
                this.configurationAsset = new SwaggerConfigurationAsset(asset.openStream());
                ((ArchiveBase)this.getArchive()).add((Asset)this.configurationAsset, node.getPath());
            }
        } else {
            this.configurationAsset = new SwaggerConfigurationAsset();
            if (((ArchiveBase)this.getArchive()).getName().endsWith(".war")) {
                ((ArchiveBase)this.getArchive()).add((Asset)this.configurationAsset, "WEB-INF/classes/META-INF/swarm.swagger.conf");
            } else {
                ((ArchiveBase)this.getArchive()).add((Asset)this.configurationAsset, "META-INF/swarm.swagger.conf");
            }
        }
    }
}

