/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jolokia.runtime;

import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.jolokia.JolokiaFraction;
import org.wildfly.swarm.jolokia.access.ConfigurationValueAccessPreparer;
import org.wildfly.swarm.spi.api.ArtifactLookup;
import org.wildfly.swarm.spi.runtime.annotations.ConfigurationValue;
import org.wildfly.swarm.undertow.WARArchive;

@ApplicationScoped
public class JolokiaWarDeploymentProducer {
    public static final String DEPLOYMENT_GAV = "org.jolokia:jolokia-war:war:*";
    public static final String DEPLOYMENT_NAME = "jolokia.war";
    @Inject
    @Any
    JolokiaFraction fraction;
    @Inject
    ArtifactLookup lookup;
    @Inject
    @ConfigurationValue(value="swarm.jolokia.access.xml")
    String jolokiaAccessXML;
    @ConfigurationValue(value="swarm.jolokia.context")
    private String context;

    @Produces
    public Archive jolokiaWar() throws Exception {
        if (this.context == null) {
            this.context = this.fraction.context();
        }
        JavaArchive deployment = this.lookup.artifact(DEPLOYMENT_GAV, DEPLOYMENT_NAME);
        ((WARArchive)deployment.as(WARArchive.class)).setContextRoot(this.context);
        Consumer<Archive> preparer = new ConfigurationValueAccessPreparer(this.jolokiaAccessXML);
        if (this.fraction.jolokiaWarPreparer() != null) {
            preparer = preparer.andThen(this.fraction.jolokiaWarPreparer());
        }
        preparer.accept((Archive)deployment);
        return deployment;
    }
}

