/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.impl.ClusterClockImpl;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.ClusterStateManager;
import com.hazelcast.cluster.impl.ConfigCheck;
import com.hazelcast.cluster.impl.ConfigMismatchException;
import com.hazelcast.cluster.impl.JoinMessage;
import com.hazelcast.cluster.impl.JoinRequest;
import com.hazelcast.cluster.impl.operations.AuthenticationFailureOperation;
import com.hazelcast.cluster.impl.operations.BeforeJoinCheckFailureOperation;
import com.hazelcast.cluster.impl.operations.ConfigMismatchOperation;
import com.hazelcast.cluster.impl.operations.FinalizeJoinOperation;
import com.hazelcast.cluster.impl.operations.GroupMismatchOperation;
import com.hazelcast.cluster.impl.operations.JoinRequestOperation;
import com.hazelcast.cluster.impl.operations.MasterDiscoveryOperation;
import com.hazelcast.cluster.impl.operations.MemberInfoUpdateOperation;
import com.hazelcast.cluster.impl.operations.PostJoinOperation;
import com.hazelcast.cluster.impl.operations.SetMasterOperation;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.partition.PartitionRuntimeState;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class ClusterJoinManager {
    private static final int CLUSTER_OPERATION_RETRY_COUNT = 100;
    private final ILogger logger;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ClusterServiceImpl clusterService;
    private final Lock clusterServiceLock;
    private final ClusterClockImpl clusterClock;
    private final ClusterStateManager clusterStateManager;
    private final Set<MemberInfo> setJoins = new LinkedHashSet<MemberInfo>(100);
    private final long maxWaitMillisBeforeJoin;
    private final long waitMillisBeforeJoin;
    private final FutureUtil.ExceptionHandler whileFinalizeJoinsExceptionHandler;
    private long firstJoinRequest;
    private long timeToStartJoin;
    private boolean joinInProgress;

    public ClusterJoinManager(Node node, ClusterServiceImpl clusterService, Lock clusterServiceLock) {
        this.node = node;
        this.clusterService = clusterService;
        this.clusterServiceLock = clusterServiceLock;
        this.nodeEngine = clusterService.getNodeEngine();
        this.logger = node.getLogger(this.getClass());
        this.clusterStateManager = clusterService.getClusterStateManager();
        this.clusterClock = clusterService.getClusterClock();
        this.maxWaitMillisBeforeJoin = node.groupProperties.getMillis(GroupProperty.MAX_WAIT_SECONDS_BEFORE_JOIN);
        this.waitMillisBeforeJoin = node.groupProperties.getMillis(GroupProperty.WAIT_SECONDS_BEFORE_JOIN);
        this.whileFinalizeJoinsExceptionHandler = FutureUtil.logAllExceptions(this.logger, "While waiting finalize join calls...", Level.WARNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinInProgress() {
        if (this.joinInProgress) {
            return true;
        }
        this.clusterServiceLock.lock();
        try {
            boolean bl = this.joinInProgress || !this.setJoins.isEmpty();
            return bl;
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    public void handleJoinRequest(JoinRequest joinRequest, Connection connection) {
        if (!this.ensureNodeIsReady()) {
            return;
        }
        if (!this.ensureValidConfiguration(joinRequest)) {
            return;
        }
        Address target = joinRequest.getAddress();
        boolean isRequestFromCurrentMaster = target.equals(this.node.getMasterAddress());
        if (!this.node.isMaster() && !isRequestFromCurrentMaster) {
            this.sendMasterAnswer(target);
            return;
        }
        if (this.joinInProgress) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Join is in progress, cannot handle join request from %s at the moment", target));
            }
            return;
        }
        this.executeJoinRequest(joinRequest, connection, target);
    }

    private boolean ensureNodeIsReady() {
        if (this.node.joined() && this.node.isRunning()) {
            return true;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Node is not ready to process join request...");
        }
        return false;
    }

    private boolean ensureValidConfiguration(JoinMessage joinMessage) {
        Address address = joinMessage.getAddress();
        try {
            if (this.isValidJoinMessage(joinMessage)) {
                return true;
            }
            this.logger.warning(String.format("Received an invalid join request from %s, cause: clusters part of different cluster-groups", address));
            this.nodeEngine.getOperationService().send(new GroupMismatchOperation(), address);
        }
        catch (ConfigMismatchException e) {
            this.logger.warning(String.format("Received an invalid join request from %s, cause: %s", address, e.getMessage()));
            InternalOperationService operationService = this.nodeEngine.getOperationService();
            operationService.send(new ConfigMismatchOperation(e.getMessage()), address);
        }
        return false;
    }

    private boolean isValidJoinMessage(JoinMessage joinMessage) {
        try {
            return this.validateJoinMessage(joinMessage);
        }
        catch (ConfigMismatchException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean validateJoinMessage(JoinMessage joinMessage) throws Exception {
        if (joinMessage.getPacketVersion() != 4) {
            return false;
        }
        try {
            ConfigCheck newMemberConfigCheck = joinMessage.getConfigCheck();
            ConfigCheck clusterConfigCheck = this.node.createConfigCheck();
            return clusterConfigCheck.isCompatible(newMemberConfigCheck);
        }
        catch (Exception e) {
            this.logger.warning(String.format("Invalid join request from %s, cause: %s", joinMessage.getAddress(), e.getMessage()));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJoinRequest(JoinRequest joinRequest, Connection connection, Address target) {
        this.clusterServiceLock.lock();
        try {
            MemberInfo memberInfo;
            if (this.checkIfJoinRequestFromAnExistingMember(joinRequest, connection)) {
                return;
            }
            if (this.checkClusterStateBeforeJoin(target)) {
                return;
            }
            long now = Clock.currentTimeMillis();
            if (this.logger.isFinestEnabled()) {
                String timeToStart = this.timeToStartJoin > 0L ? ", timeToStart: " + (this.timeToStartJoin - now) : "";
                this.logger.finest(String.format("Handling join from %s, joinInProgress: %b%s", target, this.joinInProgress, timeToStart));
            }
            if ((memberInfo = this.getMemberInfo(joinRequest, target)) == null) {
                return;
            }
            if (!this.validateJoinRequest(target)) {
                return;
            }
            this.startJoinRequest(target, now, memberInfo);
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    private boolean checkClusterStateBeforeJoin(Address target) {
        if (this.clusterStateManager.getState() == ClusterState.IN_TRANSITION) {
            String message = "Cluster state either is in transition process. Join is not allowed for now -> " + this.clusterStateManager.stateToString();
            this.logger.warning(message);
            InternalOperationService operationService = this.nodeEngine.getOperationService();
            operationService.send(new BeforeJoinCheckFailureOperation(message), target);
            return true;
        }
        if (this.clusterStateManager.getState() != ClusterState.ACTIVE && !this.clusterService.isMemberRemovedWhileClusterIsNotActive(target)) {
            String message = "Cluster state either is locked or doesn't allow new members to join -> " + this.clusterStateManager.stateToString();
            this.logger.warning(message);
            InternalOperationService operationService = this.nodeEngine.getOperationService();
            operationService.send(new BeforeJoinCheckFailureOperation(message), target);
            return true;
        }
        return false;
    }

    private MemberInfo getMemberInfo(JoinRequest joinRequest, Address target) {
        MemberInfo memberInfo = joinRequest.toMemberInfo();
        if (!this.setJoins.contains(memberInfo)) {
            try {
                this.checkSecureLogin(joinRequest, memberInfo);
            }
            catch (Exception e) {
                ILogger securityLogger = this.node.loggingService.getLogger("com.hazelcast.security");
                this.nodeEngine.getOperationService().send(new AuthenticationFailureOperation(), target);
                securityLogger.severe(e);
                return null;
            }
        }
        return memberInfo;
    }

    private void checkSecureLogin(JoinRequest joinRequest, MemberInfo newMemberInfo) {
        if (this.node.securityContext != null && !this.setJoins.contains(newMemberInfo)) {
            Credentials credentials = joinRequest.getCredentials();
            if (credentials == null) {
                throw new SecurityException("Expecting security credentials, but credentials could not be found in join request");
            }
            try {
                LoginContext loginContext = this.node.securityContext.createMemberLoginContext(credentials);
                loginContext.login();
            }
            catch (LoginException e) {
                throw new SecurityException(String.format("Authentication has failed for %s@%s, cause: %s", credentials.getPrincipal(), credentials.getEndpoint(), e.getMessage()));
            }
        }
    }

    private boolean validateJoinRequest(Address target) {
        if (this.node.isMaster()) {
            try {
                this.node.getNodeExtension().validateJoinRequest();
            }
            catch (Exception e) {
                this.logger.warning(e.getMessage());
                this.nodeEngine.getOperationService().send(new BeforeJoinCheckFailureOperation(e.getMessage()), target);
                return false;
            }
        }
        return true;
    }

    private void startJoinRequest(Address target, long now, MemberInfo memberInfo) {
        if (this.firstJoinRequest == 0L) {
            this.firstJoinRequest = now;
        }
        if (this.setJoins.add(memberInfo)) {
            this.sendMasterAnswer(target);
            if (now - this.firstJoinRequest < this.maxWaitMillisBeforeJoin) {
                this.timeToStartJoin = now + this.waitMillisBeforeJoin;
            }
        }
        if (now >= this.timeToStartJoin) {
            this.startJoin();
        }
    }

    public boolean sendJoinRequest(Address toAddress, boolean withCredentials) {
        if (toAddress == null) {
            toAddress = this.node.getMasterAddress();
        }
        JoinRequestOperation joinRequest = new JoinRequestOperation(this.node.createJoinRequest(withCredentials));
        return this.nodeEngine.getOperationService().send(joinRequest, toAddress);
    }

    public void handleMaster(Address masterAddress, Address callerAddress) {
        if (this.node.joined()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Ignoring master response %s from %s, this node is already joined", masterAddress, callerAddress));
            }
            return;
        }
        if (this.node.getThisAddress().equals(masterAddress)) {
            if (this.node.isMaster()) {
                this.logger.finest(String.format("Ignoring master response %s from %s, this node is already master", masterAddress, callerAddress));
            } else {
                this.node.setAsMaster();
            }
            return;
        }
        this.handleMasterResponse(masterAddress, callerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMasterResponse(Address masterAddress, Address callerAddress) {
        this.clusterServiceLock.lock();
        try {
            Address currentMaster;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("Handling master response %s from %s", masterAddress, callerAddress));
            }
            if ((currentMaster = this.node.getMasterAddress()) == null || currentMaster.equals(masterAddress)) {
                this.setMasterAndJoin(masterAddress);
                return;
            }
            if (currentMaster.equals(callerAddress)) {
                this.logger.info(String.format("Setting master to %s since %s says it is not master anymore", masterAddress, currentMaster));
                this.setMasterAndJoin(masterAddress);
                return;
            }
            Connection conn = this.node.connectionManager.getConnection(currentMaster);
            if (conn != null && conn.isAlive()) {
                this.logger.info(String.format("Ignoring master response %s from %s since this node has an active master %s", masterAddress, callerAddress, currentMaster));
                this.sendJoinRequest(currentMaster, true);
            } else {
                this.logger.warning(String.format("Ambiguous master response: This node has a master %s, but does not have a connection to %s. Sent master response as %s. Master field will be unset now...", currentMaster, callerAddress, masterAddress));
                this.node.setMasterAddress(null);
            }
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    private void setMasterAndJoin(Address masterAddress) {
        this.node.setMasterAddress(masterAddress);
        this.node.connectionManager.getOrConnect(masterAddress);
        if (!this.sendJoinRequest(masterAddress, true)) {
            this.logger.warning("Could not create connection to possible master " + masterAddress);
        }
    }

    public boolean sendMasterQuestion(Address toAddress) {
        Preconditions.checkNotNull(toAddress, "No endpoint is specified!");
        BuildInfo buildInfo = this.node.getBuildInfo();
        Address thisAddress = this.node.getThisAddress();
        JoinMessage joinMessage = new JoinMessage(4, buildInfo.getBuildNumber(), thisAddress, this.node.getLocalMember().getUuid(), this.node.isLiteMember(), this.node.createConfigCheck());
        return this.nodeEngine.getOperationService().send(new MasterDiscoveryOperation(joinMessage), toAddress);
    }

    public void answerMasterQuestion(JoinMessage joinMessage, Connection connection) {
        if (!this.ensureValidConfiguration(joinMessage)) {
            return;
        }
        if (this.node.getMasterAddress() != null) {
            if (!this.checkIfJoinRequestFromAnExistingMember(joinMessage, connection)) {
                this.sendMasterAnswer(joinMessage.getAddress());
            }
        } else if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("Received a master question from %s, but this node is not master itself or doesn't have a master yet!", joinMessage.getAddress()));
        }
    }

    private void sendMasterAnswer(Address target) {
        Address masterAddress = this.node.getMasterAddress();
        if (masterAddress == null) {
            this.logger.info(String.format("Cannot send master answer to %s since master node is not known yet", target));
            return;
        }
        SetMasterOperation op = new SetMasterOperation(masterAddress);
        this.nodeEngine.getOperationService().send(op, target);
    }

    boolean checkIfJoinRequestFromAnExistingMember(JoinMessage joinMessage, Connection connection) {
        MemberImpl member = this.clusterService.getMember(joinMessage.getAddress());
        if (member == null) {
            return false;
        }
        Address target = member.getAddress();
        if (joinMessage.getUuid().equals(member.getUuid())) {
            if (this.node.isMaster()) {
                Operation[] postJoinOps;
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest(String.format("Ignoring join request, member already exists: %s", joinMessage));
                }
                boolean isPostJoinOperation = (postJoinOps = this.nodeEngine.getPostJoinOperations()) != null && postJoinOps.length > 0;
                PostJoinOperation postJoinOp = isPostJoinOperation ? new PostJoinOperation(postJoinOps) : null;
                FinalizeJoinOperation operation = new FinalizeJoinOperation(ClusterServiceImpl.createMemberInfoList(this.clusterService.getMemberImpls()), postJoinOp, this.clusterClock.getClusterTime(), this.clusterStateManager.getState(), this.node.partitionService.createPartitionState(), false);
                this.nodeEngine.getOperationService().send(operation, target);
            } else {
                this.sendMasterAnswer(target);
            }
            return true;
        }
        if (this.node.isMaster() || target.equals(this.node.getMasterAddress())) {
            this.logger.warning(String.format("New join request has been received from an existing endpoint %s. Removing old member and processing join request...", member));
            this.clusterService.doRemoveAddress(target, false);
            Connection existing = this.node.connectionManager.getConnection(target);
            if (existing != connection) {
                this.node.connectionManager.destroyConnection(existing);
                this.node.connectionManager.registerConnection(target, connection);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJoin() {
        this.logger.finest("Starting join...");
        this.clusterServiceLock.lock();
        try {
            try {
                this.joinInProgress = true;
                this.node.getPartitionService().pauseMigration();
                Collection<MemberImpl> members = this.clusterService.getMemberImpls();
                List<MemberInfo> memberInfos = ClusterServiceImpl.createMemberInfoList(members);
                for (MemberInfo memberJoining : this.setJoins) {
                    memberInfos.add(memberJoining);
                }
                long time = this.clusterClock.getClusterTime();
                Operation[] postJoinOps = this.nodeEngine.getPostJoinOperations();
                boolean createPostJoinOperation = postJoinOps != null && postJoinOps.length > 0;
                PostJoinOperation postJoinOp = createPostJoinOperation ? new PostJoinOperation(postJoinOps) : null;
                int count = members.size() - 1 + this.setJoins.size();
                ArrayList<Future> calls = new ArrayList<Future>(count);
                PartitionRuntimeState partitionState = this.node.partitionService.createPartitionState();
                for (MemberInfo memberInfo : this.setJoins) {
                    long startTime = this.clusterClock.getClusterStartTime();
                    FinalizeJoinOperation joinOperation = new FinalizeJoinOperation(memberInfos, postJoinOp, time, this.clusterService.getClusterId(), startTime, this.clusterStateManager.getState(), partitionState);
                    calls.add(this.invokeClusterOperation(joinOperation, memberInfo.getAddress()));
                }
                for (MemberImpl memberImpl : members) {
                    if (memberImpl.getAddress().equals(this.clusterService.getThisAddress())) continue;
                    MemberInfoUpdateOperation infoUpdateOperation = new MemberInfoUpdateOperation(memberInfos, time, true);
                    calls.add(this.invokeClusterOperation(infoUpdateOperation, memberImpl.getAddress()));
                }
                this.clusterService.updateMembers(memberInfos);
                int timeout = Math.min(calls.size() * 5, 60);
                FutureUtil.waitWithDeadline(calls, timeout, TimeUnit.SECONDS, this.whileFinalizeJoinsExceptionHandler);
            }
            finally {
                this.node.getPartitionService().resumeMigration();
            }
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    private Future invokeClusterOperation(Operation op, Address target) {
        return this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:clusterService", op, target).setTryCount(100).invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        this.clusterServiceLock.lock();
        try {
            this.joinInProgress = false;
            this.setJoins.clear();
            this.timeToStartJoin = Clock.currentTimeMillis() + this.waitMillisBeforeJoin;
            this.firstJoinRequest = 0L;
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    void removeJoin(MemberInfo memberInfo) {
        this.setJoins.remove(memberInfo);
    }
}

