/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import java.security.Permission;

public class ClientReplicatedMapRemoveEntryListenerRequest
extends BaseClientRemoveListenerRequest {
    public ClientReplicatedMapRemoveEntryListenerRequest() {
    }

    public ClientReplicatedMapRemoveEntryListenerRequest(String mapName) {
        super(mapName);
    }

    @Override
    protected boolean deRegisterListener() {
        if (this.getClientEngine().getConfig().isLiteMember()) {
            throw new ReplicatedMapCantBeCreatedOnLiteMemberException("Listener cannot be de-registered on lite members!");
        }
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        return eventPublishingService.removeEventListener(this.getName(), this.registrationId);
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public Permission getRequiredPermission() {
        return new ReplicatedMapPermission(this.getName(), "listen");
    }

    @Override
    public String getMethodName() {
        return "removeEntryListener";
    }
}

