/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services;

import java.nio.charset.Charset;
import java.util.UUID;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebListener
public class Bootstrap
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(Bootstrap.class);

    public void contextInitialized(ServletContextEvent sce) {
        String serverId = System.getProperty("org.kie.server.id");
        String serverName = System.getProperty("org.kie.server.id");
        if (serverId == null) {
            serverName = sce.getServletContext().getServletContextName() + "@" + sce.getServletContext().getContextPath();
            serverId = UUID.nameUUIDFromBytes(serverName.getBytes(Charset.forName("UTF-8"))).toString();
        }
        KieServerEnvironment.setServerId((String)serverId.toString());
        KieServerEnvironment.setServerName((String)serverName);
        logger.info("KieServer (id {} (name {})) started initialization process", (Object)KieServerEnvironment.getServerId(), (Object)serverName);
        KieServerLocator.getInstance();
        logger.info("KieServer (id {}) started successfully", (Object)KieServerEnvironment.getServerId());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        KieServerImpl server = KieServerLocator.getInstance();
        server.destroy();
        logger.info("KieServer (id {}) destroyed successfully", (Object)KieServerEnvironment.getServerId());
    }
}

