/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.InitialContext;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.Version;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Severity;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.services.api.KieControllerNotConnectedException;
import org.kie.server.services.api.KieControllerNotDefinedException;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.ContainerManager;
import org.kie.server.services.impl.KieContainerInstanceImpl;
import org.kie.server.services.impl.KieServerRegistryImpl;
import org.kie.server.services.impl.controller.ControllerConnectRunnable;
import org.kie.server.services.impl.controller.DefaultRestControllerImpl;
import org.kie.server.services.impl.security.JACCIdentityProvider;
import org.kie.server.services.impl.storage.KieServerState;
import org.kie.server.services.impl.storage.KieServerStateRepository;
import org.kie.server.services.impl.storage.file.KieServerStateFileRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerImpl {
    private static final Logger logger = LoggerFactory.getLogger(KieServerImpl.class);
    private static final ServiceLoader<KieServerExtension> serverExtensions = ServiceLoader.load(KieServerExtension.class);
    private static final ServiceLoader<KieServerController> kieControllers = ServiceLoader.load(KieServerController.class);
    private String kieServerLocation;
    private final KieServerRegistry context;
    private final ContainerManager containerManager;
    private final KieServerStateRepository repository;
    private volatile AtomicBoolean kieServerActive;
    private List<Message> serverMessages;
    private Map<String, List<Message>> containerMessages;

    public KieServerImpl() {
        KieServerSetup kieServerSetup;
        Set containers;
        KieServerInfo kieServerInfo;
        boolean readyToRun;
        KieServerState currentState;
        block9: {
            this.kieServerLocation = System.getProperty("org.kie.server.location", "http://localhost:8230/kie-server/services/rest/server");
            this.kieServerActive = new AtomicBoolean(false);
            this.serverMessages = new ArrayList<Message>();
            this.containerMessages = new ConcurrentHashMap<String, List<Message>>();
            this.repository = new KieServerStateFileRepository();
            this.context = new KieServerRegistryImpl();
            this.context.registerIdentityProvider(new JACCIdentityProvider());
            this.context.registerStateRepository(this.repository);
            this.containerManager = this.getContainerManager();
            currentState = this.repository.load(KieServerEnvironment.getServerId());
            List<KieServerExtension> extensions = this.sortKnownExtensions();
            for (KieServerExtension extension : extensions) {
                if (!extension.isActive()) continue;
                try {
                    extension.init(this, this.context);
                    this.context.registerServerExtension(extension);
                    logger.info("{} has been successfully registered as server extension", (Object)extension);
                }
                catch (Exception e) {
                    this.serverMessages.add(new Message(Severity.ERROR, "Error when initializing server extension of type " + extension + " due to " + e.getMessage()));
                    logger.error("Error when initializing server extension of type {}", (Object)extension, (Object)e);
                }
            }
            this.kieServerActive.set(true);
            readyToRun = false;
            KieServerController kieController = this.getController();
            kieServerInfo = this.getInfoInternal();
            containers = null;
            kieServerSetup = null;
            try {
                kieServerSetup = kieController.connect(kieServerInfo);
                containers = kieServerSetup.getContainers();
                readyToRun = true;
            }
            catch (KieControllerNotDefinedException e) {
                containers = currentState.getContainers();
                kieServerSetup = new KieServerSetup();
                readyToRun = true;
            }
            catch (KieControllerNotConnectedException e) {
                readyToRun = false;
                logger.warn("Unable to connect to any controllers, delaying container installation until connection can be established");
                Thread connectToControllerThread = new Thread((Runnable)new ControllerConnectRunnable(this.kieServerActive, kieController, kieServerInfo, currentState, this.containerManager, this), "KieServer-ControllerConnect");
                connectToControllerThread.start();
                if (!Boolean.parseBoolean(currentState.getConfiguration().getConfigItemValue("org.kie.server.sync.deploy", "false"))) break block9;
                logger.info("Containers were requested to be deployed synchronously, holding application start...");
                try {
                    connectToControllerThread.join();
                }
                catch (InterruptedException e1) {
                    logger.debug("Interrupt exception when waiting for deployments");
                }
            }
        }
        if (readyToRun) {
            this.addServerStatusMessage(kieServerInfo);
            this.containerManager.installContainers(this, containers, currentState, kieServerSetup);
        }
    }

    public KieServerRegistry getServerRegistry() {
        return this.context;
    }

    public void destroy() {
        this.kieServerActive.set(false);
        KieServerController kieController = this.getController();
        kieController.disconnect(this.getInfoInternal());
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            try {
                extension.destroy(this, this.context);
                this.context.unregisterServerExtension(extension);
                logger.info("{} has been successfully unregistered as server extension", (Object)extension);
            }
            catch (Exception e) {
                logger.error("Error when destroying server extension of type {}", (Object)extension, (Object)e);
            }
        }
    }

    public List<KieServerExtension> getServerExtensions() {
        return this.context.getServerExtensions();
    }

    protected KieServerInfo getInfoInternal() {
        Version version = KieServerEnvironment.getVersion();
        String serverId = KieServerEnvironment.getServerId();
        String serverName = KieServerEnvironment.getServerName();
        String versionStr = version != null ? version.toString() : "Unknown-Version";
        ArrayList<String> capabilities = new ArrayList<String>();
        for (KieServerExtension extension : this.context.getServerExtensions()) {
            capabilities.add(extension.getImplementedCapability());
        }
        return new KieServerInfo(serverId, serverName, versionStr, capabilities, this.kieServerLocation);
    }

    public ServiceResponse<KieServerInfo> getInfo() {
        try {
            KieServerInfo kieServerInfo = this.getInfoInternal();
            kieServerInfo.setMessages(this.serverMessages);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie Server info", (Object)kieServerInfo);
        }
        catch (Exception e) {
            logger.error("Error retrieving server info:", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving kie server info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public ServiceResponse<KieContainerResource> createContainer(String containerId, KieContainerResource container) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ServiceResponse<KieContainerResourceList> listContainers() {
        try {
            ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
            for (KieContainerInstanceImpl instance : this.context.getContainers()) {
                instance.getResource().setMessages(this.getMessagesForContainer(instance.getContainerId()));
                containers.add(instance.getResource());
            }
            KieContainerResourceList cil = new KieContainerResourceList(containers);
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "List of created containers", (Object)cil);
        }
        catch (Exception e) {
            logger.error("Error retrieving list of containers", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error listing containers: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                if (ci.getResource().getScanner() == null) {
                    ci.getResource().setScanner(this.getScannerResource(ci));
                }
                ci.getResource().setMessages(this.getMessagesForContainer(id));
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Info for container " + id, (Object)ci.getResource());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving info for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container info: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public ServiceResponse<Void> disposeContainer(String containerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                KieScannerResource info = this.getScannerResource(kci);
                kci.getResource().setScanner(info);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scanner info successfully retrieved", (Object)info);
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error retrieving scanner info for container '" + id + "'.", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving scanner info for container '" + id + "': " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerResource getScannerResource(KieContainerInstanceImpl kci) {
        InternalKieScanner scanner = kci.getScanner();
        KieScannerResource info = null;
        info = scanner != null ? new KieScannerResource(this.mapStatus(scanner.getStatus()), Long.valueOf(scanner.getPollingInterval())) : new KieScannerResource(KieScannerStatus.DISPOSED);
        return info;
    }

    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (resource == null || resource.getStatus() == null) {
            logger.error("Error updating scanner for container " + id + ". Status is null: " + resource);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container " + id + ". Status is null: " + resource);
        }
        KieScannerStatus status = resource.getStatus();
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                ServiceResponse result = null;
                switch (status) {
                    case CREATED: {
                        result = this.createScanner(id, kci);
                        break;
                    }
                    case STARTED: {
                        result = this.startScanner(id, resource, kci);
                        break;
                    }
                    case STOPPED: {
                        result = this.stopScanner(id, resource, kci);
                        break;
                    }
                    case SCANNING: {
                        result = this.scanNow(id, resource, kci);
                        break;
                    }
                    case DISPOSED: {
                        result = this.disposeScanner(id, resource, kci);
                        break;
                    }
                    default: {
                        result = new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown status '" + status + "' for scanner on container " + id + ".");
                    }
                }
                kci.getResource().setScanner((KieScannerResource)result.getResult());
                return result;
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown container " + id + ".");
        }
        catch (Exception e) {
            logger.error("Error updating scanner for container '" + id + "': " + resource, (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating scanner for container '" + id + "': " + resource + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private ServiceResponse<KieScannerResource> startScanner(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.createScanner(id, kci)).getType())) {
            return response;
        }
        if (KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) && resource.getPollInterval() != null) {
            kci.getScanner().start(resource.getPollInterval().longValue());
            messages.add(new Message(Severity.INFO, "Kie scanner successfully started with interval " + resource.getPollInterval()));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        if (!KieScannerStatus.STOPPED.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            KieScannerStatus kss = this.mapStatus(kci.getScanner().getStatus());
            messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + kss));
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + kss, (Object)this.getScannerResource(kci));
        }
        if (resource.getPollInterval() == null) {
            messages.add(new Message(Severity.WARN, "Invalid polling interval: " + resource.getPollInterval()));
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid polling interval: " + resource.getPollInterval(), (Object)this.getScannerResource(kci));
        }
        messages.add(new Message(Severity.ERROR, "Unknown error starting scanner. Scanner was not started."));
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Unknown error starting scanner. Scanner was not started." + resource, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> stopScanner(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid call. Scanner is not instantiated. ", (Object)this.getScannerResource(kci));
        }
        if (KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) {
            kci.getScanner().stop();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully stopped."));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully stopped.", (Object)this.getScannerResource(kci));
        }
        KieScannerStatus kss = this.mapStatus(kci.getScanner().getStatus());
        messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + kss));
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + kss, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> scanNow(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        KieScannerStatus kss;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            this.createScanner(id, kci);
        }
        if (KieScannerStatus.STOPPED.equals((Object)(kss = this.mapStatus(kci.getScanner().getStatus()))) || KieScannerStatus.CREATED.equals((Object)kss) || KieScannerStatus.STARTED.equals((Object)kss)) {
            kci.getScanner().scanNow();
            messages.add(new Message(Severity.INFO, "Kie scanner successfully invoked."));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Scan successfully executed.", (Object)this.getScannerResource(kci));
        }
        messages.add(new Message(Severity.WARN, "Invalid kie scanner status: " + kss));
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Invalid kie scanner status: " + kss, (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> disposeScanner(String id, KieScannerResource resource, KieContainerInstanceImpl kci) {
        ServiceResponse<KieScannerResource> response;
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        if (kci.getScanner() == null) {
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Invalid call. Scanner already disposed. ", (Object)this.getScannerResource(kci));
        }
        if ((KieScannerStatus.STARTED.equals((Object)this.mapStatus(kci.getScanner().getStatus())) || KieScannerStatus.SCANNING.equals((Object)this.mapStatus(kci.getScanner().getStatus()))) && ServiceResponse.ResponseType.FAILURE.equals((Object)(response = this.stopScanner(id, resource, kci)).getType())) {
            return response;
        }
        kci.getScanner().shutdown();
        kci.setScanner(null);
        messages.add(new Message(Severity.INFO, "Kie scanner successfully created."));
        return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully shutdown.", (Object)this.getScannerResource(kci));
    }

    private ServiceResponse<KieScannerResource> createScanner(String id, KieContainerInstanceImpl kci) {
        if (kci.getScanner() == null) {
            List<Message> messages = this.getMessagesForContainer(id);
            messages.clear();
            InternalKieScanner scanner = (InternalKieScanner)KieServices.Factory.get().newKieScanner((KieContainer)kci.getKieContainer());
            kci.setScanner(scanner);
            messages.add(new Message(Severity.INFO, "Kie scanner successfully created."));
            return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Kie scanner successfully created.", (Object)this.getScannerResource(kci));
        }
        return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error creating the scanner for container " + id + ". Scanner already exists.");
    }

    public ServiceResponse<ReleaseId> getContainerReleaseId(String id) {
        try {
            KieContainerInstanceImpl ci = this.context.getContainer(id);
            if (ci != null) {
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "ReleaseId for container " + id, (Object)ci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            logger.error("Error retrieving releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error retrieving container releaseId: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public ServiceResponse<ReleaseId> updateContainerReleaseId(String id, ReleaseId releaseId) {
        if (releaseId == null) {
            logger.error("Error updating releaseId for container '" + id + "'. ReleaseId is null.");
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ". ReleaseId is null. ");
        }
        List<Message> messages = this.getMessagesForContainer(id);
        messages.clear();
        try {
            KieContainerInstanceImpl kci = this.context.getContainer(id);
            if (kci != null && kci.getKieContainer() != null) {
                Results results = kci.getKieContainer().updateToVersion((org.kie.api.builder.ReleaseId)releaseId);
                if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                    Message error = new Message(Severity.WARN, "Error updating releaseId for container " + id + " to version " + releaseId);
                    for (org.kie.api.builder.Message builderMsg : results.getMessages()) {
                        error.addMessage(builderMsg.getText());
                    }
                    messages.add(error);
                    logger.error("Error updating releaseId for container " + id + " to version " + releaseId + "\nMessages: " + results.getMessages());
                    return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating release id on container " + id + " to " + releaseId, (Object)kci.getResource().getReleaseId());
                }
                messages.add(new Message(Severity.INFO, "Release id successfully updated for container " + id));
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            KieContainerResource containerResource = new KieContainerResource(id, releaseId, KieContainerStatus.STARTED);
            ServiceResponse<KieContainerResource> response = this.createContainer(id, containerResource);
            if (response.getType().equals((Object)ServiceResponse.ResponseType.SUCCESS)) {
                kci = this.context.getContainer(id);
                return new ServiceResponse(ServiceResponse.ResponseType.SUCCESS, "Release id successfully updated.", (Object)kci.getResource().getReleaseId());
            }
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Container " + id + " is not instantiated.");
        }
        catch (Exception e) {
            if (messages != null) {
                messages.add(new Message(Severity.WARN, "Error updating releaseId for container '" + id + "' due to " + e.getMessage()));
            }
            logger.error("Error updating releaseId for container '" + id + "'", (Throwable)e);
            return new ServiceResponse(ServiceResponse.ResponseType.FAILURE, "Error updating releaseId for container " + id + ": " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private KieScannerStatus mapStatus(InternalKieScanner.Status status) {
        switch (status) {
            case STARTING: {
                return KieScannerStatus.CREATED;
            }
            case RUNNING: {
                return KieScannerStatus.STARTED;
            }
            case SCANNING: 
            case UPDATING: {
                return KieScannerStatus.SCANNING;
            }
            case STOPPED: {
                return KieScannerStatus.STOPPED;
            }
            case SHUTDOWN: {
                return KieScannerStatus.DISPOSED;
            }
        }
        return KieScannerStatus.UNKNOWN;
    }

    protected KieServerController getController() {
        DefaultRestControllerImpl controller = new DefaultRestControllerImpl(this.context);
        Iterator<KieServerController> it = kieControllers.iterator();
        if (it != null && it.hasNext()) {
            controller = it.next();
        }
        return controller;
    }

    protected ContainerManager getContainerManager() {
        try {
            return (ContainerManager)InitialContext.doLookup("java:module/ContainerManagerEJB");
        }
        catch (Exception e) {
            logger.debug("Unable to find JEE version of ContainerManager suing default one");
            return new ContainerManager();
        }
    }

    protected List<KieServerExtension> sortKnownExtensions() {
        ArrayList<KieServerExtension> extensions = new ArrayList<KieServerExtension>();
        for (KieServerExtension extension : serverExtensions) {
            extensions.add(extension);
        }
        Collections.sort(extensions, new Comparator<KieServerExtension>(){

            @Override
            public int compare(KieServerExtension e1, KieServerExtension e2) {
                return e1.getStartOrder().compareTo(e2.getStartOrder());
            }
        });
        return extensions;
    }

    public void addServerMessage(Message message) {
        this.serverMessages.add(message);
    }

    public void addServerStatusMessage(KieServerInfo kieServerInfo) {
        StringBuilder serverInfoMsg = new StringBuilder();
        serverInfoMsg.append("Server ").append(kieServerInfo).append("started successfully at ").append(new Date());
        this.serverMessages.add(new Message(Severity.INFO, serverInfoMsg.toString()));
    }

    protected List<Message> getMessagesForContainer(String containerId) {
        List<Message> messages = this.containerMessages.get(containerId);
        if (messages == null) {
            messages = new CopyOnWriteArrayList<Message>();
            this.containerMessages.put(containerId, messages);
        }
        return messages;
    }

    public String toString() {
        return "KieServer{id='" + KieServerEnvironment.getServerId() + '\'' + "name='" + KieServerEnvironment.getServerName() + '\'' + "version='" + KieServerEnvironment.getVersion() + '\'' + "location='" + this.kieServerLocation + '\'' + '}';
    }
}

