/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.resourceadapter.impl;

import io.vertx.core.Vertx;
import io.vertx.resourceadapter.VertxConnection;
import io.vertx.resourceadapter.VertxConnectionFactory;
import io.vertx.resourceadapter.impl.AbstractJcaBase;
import io.vertx.resourceadapter.impl.VertxConnectionFactoryImpl;
import io.vertx.resourceadapter.impl.VertxConnectionImpl;
import io.vertx.resourceadapter.impl.VertxManagedConnection;
import io.vertx.resourceadapter.impl.VertxPlatformFactory;
import java.io.PrintWriter;
import java.util.Set;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;

@ConnectionDefinition(connectionFactory=VertxConnectionFactory.class, connectionFactoryImpl=VertxConnectionFactoryImpl.class, connection=VertxConnection.class, connectionImpl=VertxConnectionImpl.class)
public class VertxManagedConnectionFactory
extends AbstractJcaBase
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
VertxPlatformFactory.VertxListener {
    private static final long serialVersionUID = -4650320398583270937L;
    private static Logger log = Logger.getLogger(VertxManagedConnectionFactory.class.getName());
    private ResourceAdapter ra;
    private PrintWriter logwriter;
    private Vertx vertx;

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        log.finest("createConnectionFactory()");
        return new VertxConnectionFactoryImpl(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        throw new ResourceException("Vert.x JCA adapter not supported in non-managed environment");
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        VertxPlatformFactory.instance().getOrCreateVertx(this.getVertxPlatformConfig(), this);
        return new VertxManagedConnection(this, this.vertx);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        for (Object result : connectionSet) {
            VertxManagedConnection vertMC;
            if (!(result instanceof VertxManagedConnection) || !this.equals((vertMC = (VertxManagedConnection)result).getManagementConnectionFactory())) continue;
            return vertMC;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.vertx == null ? 0 : this.vertx.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VertxManagedConnectionFactory other = (VertxManagedConnectionFactory)obj;
        return !(this.vertx == null ? other.vertx != null : !this.vertx.equals(other.vertx));
    }

    public PrintWriter getLogWriter() throws ResourceException {
        log.finest("getLogWriter()");
        return this.logwriter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        log.finest("setLogWriter()");
        this.logwriter = out;
    }

    public ResourceAdapter getResourceAdapter() {
        log.finest("getResourceAdapter()");
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        log.finest("setResourceAdapter()");
        this.ra = ra;
    }

    @Override
    public void whenReady(Vertx vertx) {
        if (vertx != null) {
            this.vertx = vertx;
        }
    }
}

