package org.wildfly.core.embedded.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import java.io.Serializable;
import org.jboss.modules.ModuleLoader;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import java.lang.NoSuchMethodException;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.ClassNotFoundException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-10-19T22:28:36-0500")
public class EmbeddedLogger_$logger extends DelegatingBasicLogger implements EmbeddedLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EmbeddedLogger_$logger.class.getName();
    public EmbeddedLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String invalidJBossHome = "WFLYEMB0011: Invalid JBoss home directory: %s";
    protected String invalidJBossHome$str() {
        return invalidJBossHome;
    }
    @Override
    public final IllegalStateException invalidJBossHome(final String jbossHome) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidJBossHome$str(), jbossHome));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moduleLoaderError = "WFLYEMB0014: Cannot load module %s from: %s";
    protected String moduleLoaderError$str() {
        return moduleLoaderError;
    }
    @Override
    public final RuntimeException moduleLoaderError(final Throwable cause, final String msg, final ModuleLoader moduleLoader) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), moduleLoaderError$str(), msg, moduleLoader), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadEmbeddedServerFactory = "WFLYEMB0017: Cannot load embedded server factory: %s";
    protected String cannotLoadEmbeddedServerFactory$str() {
        return cannotLoadEmbeddedServerFactory;
    }
    @Override
    public final IllegalStateException cannotLoadEmbeddedServerFactory(final ClassNotFoundException cause, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotLoadEmbeddedServerFactory$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGetReflectiveMethod = "WFLYEMB0018: Cannot get reflective method '%s' for: %s";
    protected String cannotGetReflectiveMethod$str() {
        return cannotGetReflectiveMethod;
    }
    @Override
    public final IllegalStateException cannotGetReflectiveMethod(final NoSuchMethodException cause, final String method, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotGetReflectiveMethod$str(), method, className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateStandaloneServer = "WFLYEMB0019: Cannot create standalone server using factory: %s";
    protected String cannotCreateStandaloneServer$str() {
        return cannotCreateStandaloneServer;
    }
    @Override
    public final IllegalStateException cannotCreateStandaloneServer(final Throwable cause, final Method createMethod) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCreateStandaloneServer$str(), createMethod), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSetupEmbeddedServer = "WFLYEMB0020: Cannot setup embedded process";
    protected String cannotSetupEmbeddedServer$str() {
        return cannotSetupEmbeddedServer;
    }
    @Override
    public final IllegalStateException cannotSetupEmbeddedServer(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSetupEmbeddedServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotStartEmbeddedServer = "WFLYEMB0021: Cannot start embedded process";
    protected String cannotStartEmbeddedServer$str() {
        return cannotStartEmbeddedServer;
    }
    @Override
    public final EmbeddedProcessStartException cannotStartEmbeddedServer(final Throwable cause) {
        final EmbeddedProcessStartException result = new EmbeddedProcessStartException(String.format(getLoggingLocale(), cannotStartEmbeddedServer$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInvokeStandaloneServer = "WFLYEMB0022: Cannot invoke '%s' on embedded process";
    protected String cannotInvokeStandaloneServer$str() {
        return cannotInvokeStandaloneServer;
    }
    @Override
    public final IllegalStateException cannotInvokeStandaloneServer(final Throwable cause, final String methodName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotInvokeStandaloneServer$str(), methodName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String processIsStopping = "WFLYEMB0023: The embedded server is stopping and invocations on the ModelControllerClient are not available";
    protected String processIsStopping$str() {
        return processIsStopping;
    }
    @Override
    public final IllegalStateException processIsStopping() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), processIsStopping$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String processIsReloading = "WFLYEMB0024: The embedded server is reloading and invocations on the ModelControllerClient are not yet available";
    protected String processIsReloading$str() {
        return processIsReloading;
    }
    @Override
    public final IllegalStateException processIsReloading() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), processIsReloading$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateHostController = "WFLYEMB0026: Cannot create host controller using factory: %s";
    protected String cannotCreateHostController$str() {
        return cannotCreateHostController;
    }
    @Override
    public final IllegalStateException cannotCreateHostController(final Throwable cause, final Method createMethod) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCreateHostController$str(), createMethod), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String processIsStopped = "WFLYEMB0027: The embedded server is stopped and invocations on the ModelControllerClient are not available";
    protected String processIsStopped$str() {
        return processIsStopped;
    }
    @Override
    public final IllegalStateException processIsStopped() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), processIsStopped$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
