/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutIfAbsentRequest
extends AbstractCacheRequest {
    private Data key;
    private Data value;
    private ExpiryPolicy expiryPolicy;
    private int completionId;

    public CachePutIfAbsentRequest() {
    }

    public CachePutIfAbsentRequest(String name, Data key, Data value, ExpiryPolicy expiryPolicy, InMemoryFormat inMemoryFormat) {
        super(name, inMemoryFormat);
        this.key = key;
        this.value = value;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        CacheOperationProvider operationProvider = this.getOperationProvider();
        return operationProvider.createPutIfAbsentOperation(this.key, this.value, this.expiryPolicy, this.completionId);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("c", this.completionId);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeData(this.value);
        out.writeObject(this.expiryPolicy);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.completionId = reader.readInt("c");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.value = in.readData();
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }

    @Override
    public void setCompletionId(Integer completionId) {
        this.completionId = completionId != null ? completionId : -1;
    }

    @Override
    public Permission getRequiredPermission() {
        return new CachePermission(this.name, "put");
    }

    @Override
    public Object[] getParameters() {
        if (this.expiryPolicy == null) {
            return new Object[]{this.key, this.value};
        }
        return new Object[]{this.key, this.value, this.expiryPolicy};
    }

    @Override
    public String getMethodName() {
        return "putIfAbsent";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

