/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.SimpleExecutionCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class MultiTargetClientRequest
extends ClientRequest {
    @Override
    public final void process() throws Exception {
        ClientEndpoint endpoint = this.getEndpoint();
        OperationFactory operationFactory = this.createOperationFactory();
        Collection<Address> targets = this.getTargets();
        if (targets.isEmpty()) {
            endpoint.sendResponse(this.reduce(new HashMap<Address, Object>()), this.getCallId());
            return;
        }
        MultiTargetCallback callback = new MultiTargetCallback(targets);
        for (Address target : targets) {
            Operation op = operationFactory.createOperation();
            op.setCallerUuid(endpoint.getUuid());
            InvocationBuilder builder = this.operationService.createInvocationBuilder(this.getServiceName(), op, target).setResultDeserialized(false).setExecutionCallback(new SingleTargetCallback(target, callback));
            builder.invoke();
        }
    }

    protected abstract OperationFactory createOperationFactory();

    protected abstract Object reduce(Map<Address, Object> var1);

    public abstract Collection<Address> getTargets();

    private static final class SingleTargetCallback
    extends SimpleExecutionCallback<Object> {
        final Address target;
        final MultiTargetCallback parent;

        private SingleTargetCallback(Address target, MultiTargetCallback parent) {
            this.target = target;
            this.parent = parent;
        }

        @Override
        public void notify(Object object) {
            this.parent.notify(this.target, object);
        }
    }

    private final class MultiTargetCallback {
        final Collection<Address> targets;
        final ConcurrentMap<Address, Object> results;

        private MultiTargetCallback(Collection<Address> targets) {
            this.targets = Collections.synchronizedSet(new HashSet<Address>(targets));
            this.results = new ConcurrentHashMap<Address, Object>(targets.size());
        }

        public void notify(Address target, Object result) {
            if (!this.targets.remove(target)) {
                if (this.results.containsKey(target)) {
                    throw new IllegalArgumentException("Duplicate response from -> " + target);
                }
                throw new IllegalArgumentException("Unknown target! -> " + target);
            }
            this.results.put(target, result);
            if (this.targets.isEmpty()) {
                Object response = MultiTargetClientRequest.this.reduce(this.results);
                MultiTargetClientRequest.this.endpoint.sendResponse(response, MultiTargetClientRequest.this.getCallId());
            }
        }
    }
}

