/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch.operations;

import com.hazelcast.concurrent.countdownlatch.CountDownLatchDataSerializerHook;
import com.hazelcast.concurrent.countdownlatch.CountDownLatchService;
import com.hazelcast.concurrent.countdownlatch.operations.BackupAwareCountDownLatchOperation;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.WaitNotifyKey;

public class CountDownOperation
extends BackupAwareCountDownLatchOperation
implements Notifier,
IdentifiedDataSerializable {
    private boolean shouldNotify;

    public CountDownOperation() {
    }

    public CountDownOperation(String name) {
        super(name);
    }

    @Override
    public void run() throws Exception {
        CountDownLatchService service = (CountDownLatchService)this.getService();
        service.countDown(this.name);
        int count = service.getCount(this.name);
        this.shouldNotify = count == 0;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public boolean shouldNotify() {
        return this.shouldNotify;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return this.waitNotifyKey();
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }
}

