/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYMODCLS", length=4)
interface ModClusterLogger
extends BasicLogger {
    public static final ModClusterLogger ROOT_LOGGER = (ModClusterLogger)Logger.getMessageLogger(ModClusterLogger.class, (String)"org.wildfly.extension.mod_cluster");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="Error adding metrics.")
    public void errorAddingMetrics(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="Mod_cluster requires Advertise but Multicast interface is not available")
    public void multicastInterfaceNotAvailable();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Mod_cluster uses default load balancer provider")
    public void useDefaultLoadBalancer();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Error applying properties to load metric class '%s'. Metric will not be loaded.")
    public void errorApplyingMetricProperties(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Metric of type '%s' is no longer supported and will be ignored.")
    public void unsupportedMetric(String var1);

    @Message(id=11, value="Virtual host '%s' or context '%s' not found")
    public String contextOrHostNotFound(String var1, String var2);

    @Message(id=14, value="Need valid host and port")
    public String needHostAndPort();

    @Message(id=15, value="session-draining-strategy must either be undefined or have the value \"DEFAULT\"")
    public String sessionDrainingStrategyMustBeUndefinedOrDefault();

    @Message(id=16, value="No IP address could be resolved for the specified host of the proxy.")
    public String couldNotResolveProxyIpAddress();

    @Message(id=17, value="'proxy-list' usage not allowed in the current model, can only be used to support older slaves")
    public String proxyListNotAllowedInCurrentModel();

    @Message(id=18, value="Usage of only one 'proxy-list' (only to support EAP 6.x slaves) or 'proxies' attributes allowed")
    public String proxyListAttributeUsage();

    @Message(id=19, value="'%s' is not a valid value for excluded-contexts.")
    public IllegalArgumentException excludedContextsWrongFormat(String var1);

    @Message(id=20, value="Only one of 'ssl-context' attribute or 'ssl' resource can be defined!")
    public IllegalStateException bothElytronAndLegacySslContextDefined();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Value 'ROOT' for excluded-contexts is deprecated, to exclude the root context use '/' instead.")
    public void excludedContextsUseSlashInsteadROOT();
}

