/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import org.jboss.as.cli.embedded.Contexts;
import org.jboss.as.cli.embedded.EmbeddedLogContext;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.stdio.SimpleStdioContextSelector;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.security.manager.WildFlySecurityManager;

class EnvironmentRestorer {
    private final String jbossHome = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.home.dir", null);
    private final String bootLog = WildFlySecurityManager.getPropertyPrivileged((String)"org.jboss.boot.log.file", null);
    private final Contexts defaultContexts = new Contexts(LogContext.getLogContext(), StdioContext.getStdioContext());
    private boolean logContextSelectorRestored;

    EnvironmentRestorer() {
    }

    Contexts getDefaultContexts() {
        return this.defaultContexts;
    }

    synchronized void restoreLogContextSelector() {
        if (!this.logContextSelectorRestored) {
            final LogContext logContext = this.defaultContexts.getLogContext();
            if (logContext == LogContext.getSystemLogContext()) {
                LogContext.setLogContextSelector((LogContextSelector)LogContext.DEFAULT_LOG_CONTEXT_SELECTOR);
            } else {
                LogContext.setLogContextSelector((LogContextSelector)new LogContextSelector(){

                    public LogContext getLogContext() {
                        return logContext;
                    }
                });
            }
            EmbeddedLogContext.clearLogContext();
            this.logContextSelectorRestored = true;
        }
    }

    void restoreEnvironment() {
        if (this.jbossHome == null) {
            WildFlySecurityManager.clearPropertyPrivileged((String)"jboss.home.dir");
        } else {
            WildFlySecurityManager.setPropertyPrivileged((String)"jboss.home.dir", (String)this.jbossHome);
        }
        if (this.bootLog == null) {
            WildFlySecurityManager.clearPropertyPrivileged((String)"org.jboss.boot.log.file");
        } else {
            WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.boot.log.file", (String)this.bootLog);
        }
        StdioContext.setStdioContextSelector((StdioContextSelector)new SimpleStdioContextSelector(this.defaultContexts.getStdioContext()));
        this.restoreLogContextSelector();
    }
}

