/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime.wildfly;

import org.jboss.as.repository.ContentRepository;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistryException;
import org.wildfly.swarm.container.runtime.wildfly.SwarmContentRepository;

public class ContentRepositoryServiceActivator
implements ServiceActivator {
    private final SwarmContentRepository repository;

    public ContentRepositoryServiceActivator(SwarmContentRepository repository) {
        this.repository = repository;
    }

    public void activate(final ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceController oldContentRepository = context.getServiceRegistry().getService(ContentRepository.SERVICE_NAME);
        oldContentRepository.addListener((ServiceListener)new AbstractServiceListener(){

            public void transition(ServiceController controller, ServiceController.Transition transition) {
                super.transition(controller, transition);
                if (transition.getAfter() == ServiceController.Substate.REMOVED) {
                    SwarmContentRepository.addService(context.getServiceTarget(), ContentRepositoryServiceActivator.this.repository);
                }
            }
        });
        oldContentRepository.setMode(ServiceController.Mode.REMOVE);
    }
}

