/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.messaging.activemq.server.ha_policy.shared_store_colocated;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Implicit;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=messaging-activemq/server=*/ha-policy=shared-store-colocated/configuration=slave")
@ResourceType(value="configuration")
@Implicit
public class SlaveConfiguration<T extends SlaveConfiguration<T>>
extends HashMap
implements Keyed {
    private String key = "slave";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @AttributeDocumentation(value="Whether a server will automatically stop when a another places a request to take over its place. The use case is when a regular server stops and its backup takes over its duties, later the main server restarts and requests the server (the former backup) to stop operating.")
    private Boolean allowFailback;
    @AttributeDocumentation(value="Whether the server must failover when it is normally shutdown.")
    private Boolean failoverOnServerShutdown;
    @AttributeDocumentation(value="Will this server, if a backup, restart once it has been stopped because of failback or scaling down.")
    private Boolean restartBackup;
    @AttributeDocumentation(value="Configure whether this server send its messages to another live server in the scale-down cluster when it is shutdown cleanly.")
    private Boolean scaleDown;
    @AttributeDocumentation(value="Name of the cluster used to scale down.")
    private String scaleDownClusterName;
    @AttributeDocumentation(value="List of connectors used to form the scale-down cluster.")
    private List<String> scaleDownConnectors;
    @AttributeDocumentation(value="Name of the discovery group used to build the scale-down cluster")
    private String scaleDownDiscoveryGroup;
    @AttributeDocumentation(value="Name of the group used to scale down.")
    private String scaleDownGroupName;

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="allow-failback")
    public Boolean allowFailback() {
        return this.allowFailback;
    }

    public T allowFailback(Boolean value) {
        Boolean oldValue = this.allowFailback;
        this.allowFailback = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("allowFailback", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="failover-on-server-shutdown")
    public Boolean failoverOnServerShutdown() {
        return this.failoverOnServerShutdown;
    }

    public T failoverOnServerShutdown(Boolean value) {
        Boolean oldValue = this.failoverOnServerShutdown;
        this.failoverOnServerShutdown = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("failoverOnServerShutdown", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="restart-backup")
    public Boolean restartBackup() {
        return this.restartBackup;
    }

    public T restartBackup(Boolean value) {
        Boolean oldValue = this.restartBackup;
        this.restartBackup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("restartBackup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down")
    public Boolean scaleDown() {
        return this.scaleDown;
    }

    public T scaleDown(Boolean value) {
        Boolean oldValue = this.scaleDown;
        this.scaleDown = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDown", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-cluster-name")
    public String scaleDownClusterName() {
        return this.scaleDownClusterName;
    }

    public T scaleDownClusterName(String value) {
        String oldValue = this.scaleDownClusterName;
        this.scaleDownClusterName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownClusterName", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-connectors")
    public List<String> scaleDownConnectors() {
        return this.scaleDownConnectors;
    }

    public T scaleDownConnectors(List<String> value) {
        List<String> oldValue = this.scaleDownConnectors;
        this.scaleDownConnectors = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownConnectors", oldValue, value);
        }
        return (T)this;
    }

    public T scaleDownConnector(String value) {
        if (this.scaleDownConnectors == null) {
            this.scaleDownConnectors = new ArrayList<String>();
        }
        this.scaleDownConnectors.add(value);
        return (T)this;
    }

    public T scaleDownConnectors(String ... args) {
        this.scaleDownConnectors(Arrays.stream(args).collect(Collectors.toList()));
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-discovery-group")
    public String scaleDownDiscoveryGroup() {
        return this.scaleDownDiscoveryGroup;
    }

    public T scaleDownDiscoveryGroup(String value) {
        String oldValue = this.scaleDownDiscoveryGroup;
        this.scaleDownDiscoveryGroup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownDiscoveryGroup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="scale-down-group-name")
    public String scaleDownGroupName() {
        return this.scaleDownGroupName;
    }

    public T scaleDownGroupName(String value) {
        String oldValue = this.scaleDownGroupName;
        this.scaleDownGroupName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("scaleDownGroupName", oldValue, value);
        }
        return (T)this;
    }
}

