/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.naming;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceType;

@Address(value="/subsystem=naming/binding=*")
@ResourceType(value="binding")
public class Binding<T extends Binding<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    @AttributeDocumentation(value="The type of binding to create, may be simple, lookup, external-context or object-factory")
    private BindingType bindingType;
    @AttributeDocumentation(value="If the external context should be cached")
    private Boolean cache;
    @AttributeDocumentation(value="The object factory class name for object factory bindings")
    private String attributeClass;
    @AttributeDocumentation(value="The environment to use on object factory instance retrieval")
    private Map environment;
    @AttributeDocumentation(value="The entry to lookup in JNDI for lookup bindings")
    private String lookup;
    @AttributeDocumentation(value="The module to load the object factory from for object factory bindings")
    private String module;
    @AttributeDocumentation(value="The type of the value to bind for simple bindings, this must be a primitive type")
    private String type;
    @AttributeDocumentation(value="The value to bind for simple bindings")
    private String value;

    public Binding(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    @ModelNodeBinding(detypedName="binding-type")
    public BindingType bindingType() {
        return this.bindingType;
    }

    public T bindingType(BindingType value) {
        BindingType oldValue = this.bindingType;
        this.bindingType = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("bindingType", (Object)oldValue, (Object)value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="cache")
    public Boolean cache() {
        return this.cache;
    }

    public T cache(Boolean value) {
        Boolean oldValue = this.cache;
        this.cache = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("cache", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="class")
    public String attributeClass() {
        return this.attributeClass;
    }

    public T attributeClass(String value) {
        String oldValue = this.attributeClass;
        this.attributeClass = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("attributeClass", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="environment")
    public Map environment() {
        return this.environment;
    }

    public T environment(Map value) {
        Map oldValue = this.environment;
        this.environment = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("environment", oldValue, value);
        }
        return (T)this;
    }

    public T environment(String key, Object value) {
        if (this.environment == null) {
            this.environment = new HashMap();
        }
        this.environment.put(key, value);
        return (T)this;
    }

    @ModelNodeBinding(detypedName="lookup")
    public String lookup() {
        return this.lookup;
    }

    public T lookup(String value) {
        String oldValue = this.lookup;
        this.lookup = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("lookup", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="module")
    public String module() {
        return this.module;
    }

    public T module(String value) {
        String oldValue = this.module;
        this.module = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("module", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="type")
    public String type() {
        return this.type;
    }

    public T type(String value) {
        String oldValue = this.type;
        this.type = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("type", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="value")
    public String value() {
        return this.value;
    }

    public T value(String value) {
        String oldValue = this.value;
        this.value = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("value", oldValue, value);
        }
        return (T)this;
    }

    public static enum BindingType {
        SIMPLE("simple"),
        OBJECT_FACTORY("object-factory"),
        LOOKUP("lookup"),
        EXTERNAL_CONTEXT("external-context");

        private final String allowedValue;

        public String getAllowedValue() {
            return this.allowedValue;
        }

        private BindingType(String allowedValue) {
            this.allowedValue = allowedValue;
        }

        public String toString() {
            return this.allowedValue;
        }
    }
}

