/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.config.remoting;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.wildfly.swarm.config.remoting.Property;
import org.wildfly.swarm.config.remoting.PropertyConsumer;
import org.wildfly.swarm.config.remoting.PropertySupplier;
import org.wildfly.swarm.config.remoting.SASLSecurity;
import org.wildfly.swarm.config.remoting.SASLSecurityConsumer;
import org.wildfly.swarm.config.remoting.SASLSecuritySupplier;
import org.wildfly.swarm.config.runtime.Address;
import org.wildfly.swarm.config.runtime.AttributeDocumentation;
import org.wildfly.swarm.config.runtime.Keyed;
import org.wildfly.swarm.config.runtime.ModelNodeBinding;
import org.wildfly.swarm.config.runtime.ResourceDocumentation;
import org.wildfly.swarm.config.runtime.ResourceType;
import org.wildfly.swarm.config.runtime.SingletonResource;
import org.wildfly.swarm.config.runtime.Subresource;
import org.wildfly.swarm.config.runtime.SubresourceInfo;

@Address(value="/subsystem=remoting/http-connector=*")
@ResourceType(value="http-connector")
public class HTTPConnector<T extends HTTPConnector<T>>
extends HashMap
implements Keyed {
    private String key;
    private PropertyChangeSupport pcs;
    private HTTPConnectorResources subresources = new HTTPConnectorResources();
    @AttributeDocumentation(value="The \"authentication-provider\" element contains the name of the authentication provider to use for incoming connections.")
    private String authenticationProvider;
    @AttributeDocumentation(value="The name (or names) of a connector in the Undertow subsystem to connect to.")
    private String connectorRef;
    @AttributeDocumentation(value="The protocol to pass into the SASL mechanisms used for authentication.")
    private String saslProtocol;
    @AttributeDocumentation(value="The associated security realm to use for authentication for this connector.")
    private String securityRealm;
    @AttributeDocumentation(value="The server name to send in the initial message exchange and for SASL based authentication.")
    private String serverName;

    public HTTPConnector(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (null == this.pcs) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public HTTPConnectorResources subresources() {
        return this.subresources;
    }

    public T properties(List<Property> value) {
        this.subresources.properties = value;
        return (T)this;
    }

    public T property(Property value) {
        this.subresources.properties.add(value);
        return (T)this;
    }

    public T property(String childKey, PropertyConsumer consumer) {
        Property child = new Property(childKey);
        if (consumer != null) {
            consumer.accept(child);
        }
        this.property(child);
        return (T)this;
    }

    public T property(String childKey) {
        this.property(childKey, null);
        return (T)this;
    }

    public T property(PropertySupplier supplier) {
        this.property(supplier.get());
        return (T)this;
    }

    public T saslSecurity(SASLSecurity value) {
        this.subresources.saslSecurity = value;
        return (T)this;
    }

    public T saslSecurity(SASLSecurityConsumer consumer) {
        SASLSecurity child = new SASLSecurity();
        if (consumer != null) {
            consumer.accept(child);
        }
        this.subresources.saslSecurity = child;
        return (T)this;
    }

    public T saslSecurity() {
        SASLSecurity child = new SASLSecurity();
        this.subresources.saslSecurity = child;
        return (T)this;
    }

    public T saslSecurity(SASLSecuritySupplier supplier) {
        this.subresources.saslSecurity = supplier.get();
        return (T)this;
    }

    @ModelNodeBinding(detypedName="authentication-provider")
    public String authenticationProvider() {
        return this.authenticationProvider;
    }

    public T authenticationProvider(String value) {
        String oldValue = this.authenticationProvider;
        this.authenticationProvider = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("authenticationProvider", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="connector-ref")
    public String connectorRef() {
        return this.connectorRef;
    }

    public T connectorRef(String value) {
        String oldValue = this.connectorRef;
        this.connectorRef = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("connectorRef", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="sasl-protocol")
    public String saslProtocol() {
        return this.saslProtocol;
    }

    public T saslProtocol(String value) {
        String oldValue = this.saslProtocol;
        this.saslProtocol = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("saslProtocol", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="security-realm")
    public String securityRealm() {
        return this.securityRealm;
    }

    public T securityRealm(String value) {
        String oldValue = this.securityRealm;
        this.securityRealm = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("securityRealm", oldValue, value);
        }
        return (T)this;
    }

    @ModelNodeBinding(detypedName="server-name")
    public String serverName() {
        return this.serverName;
    }

    public T serverName(String value) {
        String oldValue = this.serverName;
        this.serverName = value;
        if (this.pcs != null) {
            this.pcs.firePropertyChange("serverName", oldValue, value);
        }
        return (T)this;
    }

    public static class HTTPConnectorResources {
        @ResourceDocumentation(value="Properties supported by the underlying provider. The property name is inferred from the last element of the properties address.")
        @SubresourceInfo(value="property")
        private List<Property> properties = new ArrayList<Property>();
        @SingletonResource
        @ResourceDocumentation(value="The \"sasl\" element contains the SASL authentication configuration for this connector.")
        private SASLSecurity saslSecurity;

        @Subresource
        public List<Property> properties() {
            return this.properties;
        }

        public Property property(String key) {
            return this.properties.stream().filter(e -> e.getKey().equals(key)).findFirst().orElse(null);
        }

        @Subresource
        public SASLSecurity saslSecurity() {
            return this.saslSecurity;
        }
    }
}

