/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.net.URL;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.weld.xml.BeansXmlHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class PropertyReplacingBeansXmlHandler
extends BeansXmlHandler {
    private final PropertyReplacer replacer;

    public PropertyReplacingBeansXmlHandler(URL file, PropertyReplacer replacer) {
        super(file);
        this.replacer = replacer;
    }

    public void warning(SAXParseException e) throws SAXException {
        WeldLogger.DEPLOYMENT_LOGGER.beansXmlValidationWarning(this.file, e.getLineNumber(), e.getMessage());
    }

    public void error(SAXParseException e) throws SAXException {
        if (e.getMessage().equals("cvc-elt.1: Cannot find the declaration of element 'beans'.")) {
            return;
        }
        WeldLogger.DEPLOYMENT_LOGGER.beansXmlValidationError(this.file, e.getLineNumber(), e.getMessage());
    }

    protected String interpolate(String text) {
        if (text == null) {
            return null;
        }
        return this.replacer.replaceProperties(text);
    }
}

