/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy.processor;

import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.ribbon.ClientOptions;
import com.netflix.ribbon.ResourceGroup;
import com.netflix.ribbon.RibbonResourceFactory;
import com.netflix.ribbon.proxy.annotation.ClientProperties;
import com.netflix.ribbon.proxy.processor.AnnotationProcessor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;

public class ClientPropertiesProcessor
implements AnnotationProcessor<ResourceGroup.GroupBuilder, ResourceGroup.TemplateBuilder> {
    @Override
    public void process(String templateName, ResourceGroup.TemplateBuilder templateBuilder, Method method) {
    }

    @Override
    public void process(String groupName, ResourceGroup.GroupBuilder groupBuilder, RibbonResourceFactory resourceFactory, Class<?> interfaceClass) {
        ClientProperties properties = interfaceClass.getAnnotation(ClientProperties.class);
        if (properties != null) {
            IClientConfig config = resourceFactory.getClientConfigFactory().newConfig();
            for (ClientProperties.Property prop : properties.properties()) {
                String name = prop.name();
                config.set(CommonClientConfigKey.valueOf((String)name), (Object)prop.value());
            }
            ClientOptions options = ClientOptions.from(config);
            groupBuilder.withClientOptions(options);
            if (properties.exportToArchaius()) {
                this.exportPropertiesToArchaius(groupName, config, interfaceClass.getName());
            }
        }
    }

    private void exportPropertiesToArchaius(String groupName, IClientConfig config, String configName) {
        AggregatedConfiguration ac;
        Map map = config.getProperties();
        AbstractConfiguration configuration = ConfigurationManager.getConfigInstance();
        if (configuration instanceof AggregatedConfiguration && (configuration = (ac = (AggregatedConfiguration)configuration).getConfiguration(configName)) == null) {
            configuration = new ConcurrentMapConfiguration();
            ac.addConfiguration(configuration, configName);
        }
        for (Map.Entry entry : map.entrySet()) {
            configuration.setProperty(groupName + "." + config.getNameSpace() + "." + (String)entry.getKey(), entry.getValue());
        }
    }
}

