/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.swagger;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.StringHelper;

final class RestSwaggerHelper {
    private static final Pattern HOST_PATTERN = Pattern.compile("https?://[^:]+(:\\d+)?", 2);

    private RestSwaggerHelper() {
    }

    public static String isMediaRange(String given, String name) {
        return StringHelper.notEmpty((String)given, (String)name);
    }

    static String isHostParam(String given) {
        String hostUri = StringHelper.notEmpty((String)given, (String)"host");
        Matcher matcher = HOST_PATTERN.matcher(given);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("host must be an apsolute URI (e.g. http://api.example.com), given: `" + hostUri + "`");
        }
        return hostUri;
    }
}

