/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import com.dropbox.core.DbxEntry;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.apache.camel.component.dropbox.util.DropboxResultHeader;

public class DropboxSearchProducer
extends DropboxProducer {
    public DropboxSearchProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        DropboxSearchResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).search(this.configuration.getRemotePath(), this.configuration.getQuery());
        StringBuilder fileExtracted = new StringBuilder();
        for (DbxEntry entry : result.getFound()) {
            fileExtracted.append(entry.name).append("-").append(entry.path).append("\n");
        }
        exchange.getIn().setHeader(DropboxResultHeader.FOUND_FILES.name(), (Object)fileExtracted.toString());
        exchange.getIn().setBody(result.getFound());
    }
}

