package org.wildfly.swarm.config.management.security_realm.server_identity;

import org.wildfly.swarm.config.management.security_realm.server_identity.Keytab;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface KeytabConsumer<T extends Keytab<T>> {

	/**
	 * Configure a pre-constructed instance of Keytab resource
	 * 
	 * @parameter Instance of Keytab to configure
	 * @return nothing
	 */
	void accept(T value);

	default KeytabConsumer<T> andThen(KeytabConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}