package org.wildfly.swarm.config.management.service;

import org.wildfly.swarm.config.management.service.ActiveOperation;
import java.lang.FunctionalInterface;

@FunctionalInterface
public interface ActiveOperationConsumer<T extends ActiveOperation<T>> {

	/**
	 * Configure a pre-constructed instance of ActiveOperation resource
	 * 
	 * @parameter Instance of ActiveOperation to configure
	 * @return nothing
	 */
	void accept(T value);

	default ActiveOperationConsumer<T> andThen(ActiveOperationConsumer<T> after) {
		return (c) -> {
			this.accept(c);
			after.accept(c);
		};
	}
}