package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> annotation-propertyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface AnnotationPropertyType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:string ElementType : description
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>description</code> elements, 
    * a new <code>description</code> element 
    * @param values list of <code>description</code> objects 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> description(String ... values);

   /**
    * Returns all <code>description</code> elements
    * @return list of <code>description</code> 
    */
   public List<String> getAllDescription();

   /**
    * Removes the <code>description</code> element 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removeAllDescription();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:token ElementType : property-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>property-name</code> element
    * @param propertyName the value for the element <code>property-name</code> 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> propertyName(String propertyName);

   /**
    * Returns the <code>property-name</code> element
    * @return the node defined for the element <code>property-name</code> 
    */
   public String getPropertyName();

   /**
    * Removes the <code>property-name</code> element 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removePropertyName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:token ElementType : property-value
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>property-value</code> element
    * @param propertyValue the value for the element <code>property-value</code> 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> propertyValue(String propertyValue);

   /**
    * Returns the <code>property-value</code> element
    * @return the node defined for the element <code>property-value</code> 
    */
   public String getPropertyValue();

   /**
    * Removes the <code>property-value</code> element 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removePropertyValue();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationPropertyType ElementName: xsd:ID ElementType : id
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>id</code> attribute
    * @param id the value for the attribute <code>id</code> 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> id(String id);

   /**
    * Returns the <code>id</code> attribute
    * @return the value defined for the attribute <code>id</code> 
    */
   public String getId();

   /**
    * Removes the <code>id</code> attribute 
    * @return the current instance of <code>AnnotationPropertyType<T></code> 
    */
   public AnnotationPropertyType<T> removeId();
}
