package org.jboss.shrinkwrap.descriptor.api.jboss51; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> pool-configType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface PoolConfigType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolConfigType ElementName: javaee:string ElementType : pool-value
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pool-value</code> element
    * @param poolValue the value for the element <code>pool-value</code> 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> poolValue(String poolValue);

   /**
    * Returns the <code>pool-value</code> element
    * @return the node defined for the element <code>pool-value</code> 
    */
   public String getPoolValue();

   /**
    * Removes the <code>pool-value</code> element 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> removePoolValue();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolConfigType ElementName: javaee:xsdIntegerType ElementType : pool-max-size
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pool-max-size</code> element
    * @param poolMaxSize the value for the element <code>pool-max-size</code> 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> poolMaxSize(Integer poolMaxSize);

   /**
    * Returns the <code>pool-max-size</code> element
    * @return the node defined for the element <code>pool-max-size</code> 
    */
   public Integer getPoolMaxSize();

   /**
    * Removes the <code>pool-max-size</code> element 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> removePoolMaxSize();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: PoolConfigType ElementName: javaee:xsdIntegerType ElementType : pool-timeout
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>pool-timeout</code> element
    * @param poolTimeout the value for the element <code>pool-timeout</code> 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> poolTimeout(Integer poolTimeout);

   /**
    * Returns the <code>pool-timeout</code> element
    * @return the node defined for the element <code>pool-timeout</code> 
    */
   public Integer getPoolTimeout();

   /**
    * Removes the <code>pool-timeout</code> element 
    * @return the current instance of <code>PoolConfigType<T></code> 
    */
   public PoolConfigType<T> removePoolTimeout();
}
