package org.jboss.shrinkwrap.descriptor.api.jbossdeployment10; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.FilterType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.ResourcesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment10.TransformerSetType;
/**
 * This interface defines the contract for the <code> deploymentType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface DeploymentType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<DeploymentType<T>></code> 
    */
   public FilterType<DeploymentType<T>> getOrCreateExports();

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExports();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<DeploymentType<T>></code> 
    */
   public DependenciesType<DeploymentType<T>> getOrCreateDependencies();

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeDependencies();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:exclusionsType ElementType : exclusions
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exclusions</code> element with the given value will be created.
    * Otherwise, the existing <code>exclusions</code> element will be returned.
    * @return  a new or existing instance of <code>ExclusionsType<DeploymentType<T>></code> 
    */
   public ExclusionsType<DeploymentType<T>> getOrCreateExclusions();

   /**
    * Removes the <code>exclusions</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeExclusions();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<DeploymentType<T>></code> 
    */
   public ResourcesType<DeploymentType<T>> getOrCreateResources();

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeResources();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DeploymentType ElementName: jboss:transformerSetType ElementType : transformers
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>transformers</code> element with the given value will be created.
    * Otherwise, the existing <code>transformers</code> element will be returned.
    * @return  a new or existing instance of <code>TransformerSetType<DeploymentType<T>></code> 
    */
   public TransformerSetType<DeploymentType<T>> getOrCreateTransformers();

   /**
    * Removes the <code>transformers</code> element 
    * @return the current instance of <code>DeploymentType<T></code> 
    */
   public DeploymentType<T> removeTransformers();
}
