package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletSecurityType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.RunAsType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.MultipartConfigType;
/**
 * This interface defines the contract for the <code> annotationType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface AnnotationType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: xsd:token ElementType : class-name
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>class-name</code> element
    * @param className the value for the element <code>class-name</code> 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> className(String className);

   /**
    * Returns the <code>class-name</code> element
    * @return the node defined for the element <code>class-name</code> 
    */
   public String getClassName();

   /**
    * Removes the <code>class-name</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeClassName();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:servlet-securityType ElementType : servlet-security
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>servlet-security</code> element with the given value will be created.
    * Otherwise, the existing <code>servlet-security</code> element will be returned.
    * @return  a new or existing instance of <code>ServletSecurityType<AnnotationType<T>></code> 
    */
   public ServletSecurityType<AnnotationType<T>> getOrCreateServletSecurity();

   /**
    * Removes the <code>servlet-security</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeServletSecurity();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:run-asType ElementType : run-as
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>run-as</code> element with the given value will be created.
    * Otherwise, the existing <code>run-as</code> element will be returned.
    * @return  a new or existing instance of <code>RunAsType<AnnotationType<T>></code> 
    */
   public RunAsType<AnnotationType<T>> getOrCreateRunAs();

   /**
    * Removes the <code>run-as</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeRunAs();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: AnnotationType ElementName: jboss:multipart-configType ElementType : multipart-config
   // MaxOccurs: -1  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>multipart-config</code> element with the given value will be created.
    * Otherwise, the existing <code>multipart-config</code> element will be returned.
    * @return  a new or existing instance of <code>MultipartConfigType<AnnotationType<T>></code> 
    */
   public MultipartConfigType<AnnotationType<T>> getOrCreateMultipartConfig();

   /**
    * Removes the <code>multipart-config</code> element 
    * @return the current instance of <code>AnnotationType<T></code> 
    */
   public AnnotationType<T> removeMultipartConfig();
}
