package org.jboss.shrinkwrap.descriptor.api.jbossweb60; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ClassLoadingType;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;
import org.jboss.shrinkwrap.descriptor.api.javaee6.GenericBooleanType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ReplicationConfigType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.SecurityRoleType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.MessageDestinationType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.WebserviceDescriptionType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.ServletType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.PassivationConfigType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.AnnotationType;
import org.jboss.shrinkwrap.descriptor.api.jbossweb60.JbossWebVersionType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.EnvEntryType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.EjbRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.EjbLocalRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.ResourceRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.ResourceEnvRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.MessageDestinationRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.PersistenceContextRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.PersistenceUnitRefType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.LifecycleCallbackType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.LifecycleCallbackType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.DataSourceType;
import org.jboss.shrinkwrap.descriptor.api.jbosscommon60.ServiceRefType;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.shrinkwrap.descriptor.api.DescriptorNamespace;

/** 
 * <p> 
 * This deployment descriptor provides the functionalities as described in the  specification
 * <p> 
 * Example:
 * <p> 
 * <code> 
 *     JbossWebDescriptor descriptor = Descriptors.create(JbossWebDescriptor.class);
 * </code> 
 *
 *
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface JbossWebDescriptor extends Descriptor, DescriptorNamespace<JbossWebDescriptor> {

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:env-entryType ElementType : env-entry
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>env-entry</code> element will be created and returned.
    * Otherwise, the first existing <code>env-entry</code> element will be returned.
    * @return the instance defined for the element <code>env-entry</code> 
    */
   public EnvEntryType<JbossWebDescriptor> getOrCreateEnvEntry();

   /**
    * Creates a new <code>env-entry</code> element 
    * @return the new created instance of <code>EnvEntryType<JbossWebDescriptor></code> 
    */
   public EnvEntryType<JbossWebDescriptor> createEnvEntry();

   /**
    * Returns all <code>env-entry</code> elements
    * @return list of <code>env-entry</code> 
    */
   public List<EnvEntryType<JbossWebDescriptor>> getAllEnvEntry();

   /**
    * Removes all <code>env-entry</code> elements 
    * @return the current instance of <code>EnvEntryType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllEnvEntry();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:ejb-refType ElementType : ejb-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-ref</code> 
    */
   public EjbRefType<JbossWebDescriptor> getOrCreateEjbRef();

   /**
    * Creates a new <code>ejb-ref</code> element 
    * @return the new created instance of <code>EjbRefType<JbossWebDescriptor></code> 
    */
   public EjbRefType<JbossWebDescriptor> createEjbRef();

   /**
    * Returns all <code>ejb-ref</code> elements
    * @return list of <code>ejb-ref</code> 
    */
   public List<EjbRefType<JbossWebDescriptor>> getAllEjbRef();

   /**
    * Removes all <code>ejb-ref</code> elements 
    * @return the current instance of <code>EjbRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllEjbRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:ejb-local-refType ElementType : ejb-local-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>ejb-local-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>ejb-local-ref</code> element will be returned.
    * @return the instance defined for the element <code>ejb-local-ref</code> 
    */
   public EjbLocalRefType<JbossWebDescriptor> getOrCreateEjbLocalRef();

   /**
    * Creates a new <code>ejb-local-ref</code> element 
    * @return the new created instance of <code>EjbLocalRefType<JbossWebDescriptor></code> 
    */
   public EjbLocalRefType<JbossWebDescriptor> createEjbLocalRef();

   /**
    * Returns all <code>ejb-local-ref</code> elements
    * @return list of <code>ejb-local-ref</code> 
    */
   public List<EjbLocalRefType<JbossWebDescriptor>> getAllEjbLocalRef();

   /**
    * Removes all <code>ejb-local-ref</code> elements 
    * @return the current instance of <code>EjbLocalRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllEjbLocalRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:resource-refType ElementType : resource-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-ref</code> 
    */
   public ResourceRefType<JbossWebDescriptor> getOrCreateResourceRef();

   /**
    * Creates a new <code>resource-ref</code> element 
    * @return the new created instance of <code>ResourceRefType<JbossWebDescriptor></code> 
    */
   public ResourceRefType<JbossWebDescriptor> createResourceRef();

   /**
    * Returns all <code>resource-ref</code> elements
    * @return list of <code>resource-ref</code> 
    */
   public List<ResourceRefType<JbossWebDescriptor>> getAllResourceRef();

   /**
    * Removes all <code>resource-ref</code> elements 
    * @return the current instance of <code>ResourceRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllResourceRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:resource-env-refType ElementType : resource-env-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resource-env-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>resource-env-ref</code> element will be returned.
    * @return the instance defined for the element <code>resource-env-ref</code> 
    */
   public ResourceEnvRefType<JbossWebDescriptor> getOrCreateResourceEnvRef();

   /**
    * Creates a new <code>resource-env-ref</code> element 
    * @return the new created instance of <code>ResourceEnvRefType<JbossWebDescriptor></code> 
    */
   public ResourceEnvRefType<JbossWebDescriptor> createResourceEnvRef();

   /**
    * Returns all <code>resource-env-ref</code> elements
    * @return list of <code>resource-env-ref</code> 
    */
   public List<ResourceEnvRefType<JbossWebDescriptor>> getAllResourceEnvRef();

   /**
    * Removes all <code>resource-env-ref</code> elements 
    * @return the current instance of <code>ResourceEnvRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllResourceEnvRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:message-destination-refType ElementType : message-destination-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination-ref</code> element will be returned.
    * @return the instance defined for the element <code>message-destination-ref</code> 
    */
   public MessageDestinationRefType<JbossWebDescriptor> getOrCreateMessageDestinationRef();

   /**
    * Creates a new <code>message-destination-ref</code> element 
    * @return the new created instance of <code>MessageDestinationRefType<JbossWebDescriptor></code> 
    */
   public MessageDestinationRefType<JbossWebDescriptor> createMessageDestinationRef();

   /**
    * Returns all <code>message-destination-ref</code> elements
    * @return list of <code>message-destination-ref</code> 
    */
   public List<MessageDestinationRefType<JbossWebDescriptor>> getAllMessageDestinationRef();

   /**
    * Removes all <code>message-destination-ref</code> elements 
    * @return the current instance of <code>MessageDestinationRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllMessageDestinationRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:persistence-context-refType ElementType : persistence-context-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>persistence-context-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>persistence-context-ref</code> element will be returned.
    * @return the instance defined for the element <code>persistence-context-ref</code> 
    */
   public PersistenceContextRefType<JbossWebDescriptor> getOrCreatePersistenceContextRef();

   /**
    * Creates a new <code>persistence-context-ref</code> element 
    * @return the new created instance of <code>PersistenceContextRefType<JbossWebDescriptor></code> 
    */
   public PersistenceContextRefType<JbossWebDescriptor> createPersistenceContextRef();

   /**
    * Returns all <code>persistence-context-ref</code> elements
    * @return list of <code>persistence-context-ref</code> 
    */
   public List<PersistenceContextRefType<JbossWebDescriptor>> getAllPersistenceContextRef();

   /**
    * Removes all <code>persistence-context-ref</code> elements 
    * @return the current instance of <code>PersistenceContextRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPersistenceContextRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:persistence-unit-refType ElementType : persistence-unit-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>persistence-unit-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>persistence-unit-ref</code> element will be returned.
    * @return the instance defined for the element <code>persistence-unit-ref</code> 
    */
   public PersistenceUnitRefType<JbossWebDescriptor> getOrCreatePersistenceUnitRef();

   /**
    * Creates a new <code>persistence-unit-ref</code> element 
    * @return the new created instance of <code>PersistenceUnitRefType<JbossWebDescriptor></code> 
    */
   public PersistenceUnitRefType<JbossWebDescriptor> createPersistenceUnitRef();

   /**
    * Returns all <code>persistence-unit-ref</code> elements
    * @return list of <code>persistence-unit-ref</code> 
    */
   public List<PersistenceUnitRefType<JbossWebDescriptor>> getAllPersistenceUnitRef();

   /**
    * Removes all <code>persistence-unit-ref</code> elements 
    * @return the current instance of <code>PersistenceUnitRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPersistenceUnitRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:lifecycle-callbackType ElementType : post-construct
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>post-construct</code> element will be created and returned.
    * Otherwise, the first existing <code>post-construct</code> element will be returned.
    * @return the instance defined for the element <code>post-construct</code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> getOrCreatePostConstruct();

   /**
    * Creates a new <code>post-construct</code> element 
    * @return the new created instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> createPostConstruct();

   /**
    * Returns all <code>post-construct</code> elements
    * @return list of <code>post-construct</code> 
    */
   public List<LifecycleCallbackType<JbossWebDescriptor>> getAllPostConstruct();

   /**
    * Removes all <code>post-construct</code> elements 
    * @return the current instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPostConstruct();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:lifecycle-callbackType ElementType : pre-destroy
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>pre-destroy</code> element will be created and returned.
    * Otherwise, the first existing <code>pre-destroy</code> element will be returned.
    * @return the instance defined for the element <code>pre-destroy</code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> getOrCreatePreDestroy();

   /**
    * Creates a new <code>pre-destroy</code> element 
    * @return the new created instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public LifecycleCallbackType<JbossWebDescriptor> createPreDestroy();

   /**
    * Returns all <code>pre-destroy</code> elements
    * @return list of <code>pre-destroy</code> 
    */
   public List<LifecycleCallbackType<JbossWebDescriptor>> getAllPreDestroy();

   /**
    * Removes all <code>pre-destroy</code> elements 
    * @return the current instance of <code>LifecycleCallbackType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllPreDestroy();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:data-sourceType ElementType : data-source
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>data-source</code> element will be created and returned.
    * Otherwise, the first existing <code>data-source</code> element will be returned.
    * @return the instance defined for the element <code>data-source</code> 
    */
   public DataSourceType<JbossWebDescriptor> getOrCreateDataSource();

   /**
    * Creates a new <code>data-source</code> element 
    * @return the new created instance of <code>DataSourceType<JbossWebDescriptor></code> 
    */
   public DataSourceType<JbossWebDescriptor> createDataSource();

   /**
    * Returns all <code>data-source</code> elements
    * @return list of <code>data-source</code> 
    */
   public List<DataSourceType<JbossWebDescriptor>> getAllDataSource();

   /**
    * Removes all <code>data-source</code> elements 
    * @return the current instance of <code>DataSourceType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllDataSource();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:service-refType ElementType : service-ref
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>service-ref</code> element will be created and returned.
    * Otherwise, the first existing <code>service-ref</code> element will be returned.
    * @return the instance defined for the element <code>service-ref</code> 
    */
   public ServiceRefType<JbossWebDescriptor> getOrCreateServiceRef();

   /**
    * Creates a new <code>service-ref</code> element 
    * @return the new created instance of <code>ServiceRefType<JbossWebDescriptor></code> 
    */
   public ServiceRefType<JbossWebDescriptor> createServiceRef();

   /**
    * Returns all <code>service-ref</code> elements
    * @return list of <code>service-ref</code> 
    */
   public List<ServiceRefType<JbossWebDescriptor>> getAllServiceRef();

   /**
    * Removes all <code>service-ref</code> elements 
    * @return the current instance of <code>ServiceRefType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllServiceRef();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:class-loadingType ElementType : class-loading
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>class-loading</code> element with the given value will be created.
    * Otherwise, the existing <code>class-loading</code> element will be returned.
    * @return  a new or existing instance of <code>ClassLoadingType<JbossWebDescriptor></code> 
    */
   public ClassLoadingType<JbossWebDescriptor> getOrCreateClassLoading();

   /**
    * Removes the <code>class-loading</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeClassLoading();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: xsd:token ElementType : security-domain
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>security-domain</code> element
    * @param securityDomain the value for the element <code>security-domain</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor securityDomain(String securityDomain);

   /**
    * Returns the <code>security-domain</code> element
    * @return the node defined for the element <code>security-domain</code> 
    */
   public String getSecurityDomain();

   /**
    * Removes the <code>security-domain</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeSecurityDomain();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:generic-booleanType ElementType : jacc-star-role-allow
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>jacc-star-role-allow</code> element
    * @param jaccStarRoleAllow the value for the element <code>jacc-star-role-allow</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor jaccStarRoleAllow(GenericBooleanType jaccStarRoleAllow);
   /**
    * Sets the <code>jacc-star-role-allow</code> element
    * @param jaccStarRoleAllow the value for the element <code>jacc-star-role-allow</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor jaccStarRoleAllow(String jaccStarRoleAllow);

   /**
    * Returns the <code>jacc-star-role-allow</code> element
    * @return the value found for the element <code>jacc-star-role-allow</code> 
    */
   public GenericBooleanType getJaccStarRoleAllow();

   /**
    * Returns the <code>jacc-star-role-allow</code> element
    * @return the value found for the element <code>jacc-star-role-allow</code> 
    */
   public String  getJaccStarRoleAllowAsString();

   /**
    * Removes the <code>jacc-star-role-allow</code> attribute 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeJaccStarRoleAllow();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:string ElementType : context-root
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>context-root</code> element
    * @param contextRoot the value for the element <code>context-root</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor contextRoot(String contextRoot);

   /**
    * Returns the <code>context-root</code> element
    * @return the node defined for the element <code>context-root</code> 
    */
   public String getContextRoot();

   /**
    * Removes the <code>context-root</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeContextRoot();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:string ElementType : virtual-host
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>virtual-host</code> elements, 
    * a new <code>virtual-host</code> element 
    * @param values list of <code>virtual-host</code> objects 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor virtualHost(String ... values);

   /**
    * Returns all <code>virtual-host</code> elements
    * @return list of <code>virtual-host</code> 
    */
   public List<String> getAllVirtualHost();

   /**
    * Removes the <code>virtual-host</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeAllVirtualHost();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: javaee:generic-booleanType ElementType : use-session-cookies
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||
   /**
    * Sets the <code>use-session-cookies</code> element
    * @param useSessionCookies the value for the element <code>use-session-cookies</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor useSessionCookies(GenericBooleanType useSessionCookies);
   /**
    * Sets the <code>use-session-cookies</code> element
    * @param useSessionCookies the value for the element <code>use-session-cookies</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor useSessionCookies(String useSessionCookies);

   /**
    * Returns the <code>use-session-cookies</code> element
    * @return the value found for the element <code>use-session-cookies</code> 
    */
   public GenericBooleanType getUseSessionCookies();

   /**
    * Returns the <code>use-session-cookies</code> element
    * @return the value found for the element <code>use-session-cookies</code> 
    */
   public String  getUseSessionCookiesAsString();

   /**
    * Removes the <code>use-session-cookies</code> attribute 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeUseSessionCookies();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:replication-configType ElementType : replication-config
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>replication-config</code> element with the given value will be created.
    * Otherwise, the existing <code>replication-config</code> element will be returned.
    * @return  a new or existing instance of <code>ReplicationConfigType<JbossWebDescriptor></code> 
    */
   public ReplicationConfigType<JbossWebDescriptor> getOrCreateReplicationConfig();

   /**
    * Removes the <code>replication-config</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeReplicationConfig();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:security-roleType ElementType : security-role
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>security-role</code> element will be created and returned.
    * Otherwise, the first existing <code>security-role</code> element will be returned.
    * @return the instance defined for the element <code>security-role</code> 
    */
   public SecurityRoleType<JbossWebDescriptor> getOrCreateSecurityRole();

   /**
    * Creates a new <code>security-role</code> element 
    * @return the new created instance of <code>SecurityRoleType<JbossWebDescriptor></code> 
    */
   public SecurityRoleType<JbossWebDescriptor> createSecurityRole();

   /**
    * Returns all <code>security-role</code> elements
    * @return list of <code>security-role</code> 
    */
   public List<SecurityRoleType<JbossWebDescriptor>> getAllSecurityRole();

   /**
    * Removes all <code>security-role</code> elements 
    * @return the current instance of <code>SecurityRoleType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllSecurityRole();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:message-destinationType ElementType : message-destination
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>message-destination</code> element will be created and returned.
    * Otherwise, the first existing <code>message-destination</code> element will be returned.
    * @return the instance defined for the element <code>message-destination</code> 
    */
   public MessageDestinationType<JbossWebDescriptor> getOrCreateMessageDestination();

   /**
    * Creates a new <code>message-destination</code> element 
    * @return the new created instance of <code>MessageDestinationType<JbossWebDescriptor></code> 
    */
   public MessageDestinationType<JbossWebDescriptor> createMessageDestination();

   /**
    * Returns all <code>message-destination</code> elements
    * @return list of <code>message-destination</code> 
    */
   public List<MessageDestinationType<JbossWebDescriptor>> getAllMessageDestination();

   /**
    * Removes all <code>message-destination</code> elements 
    * @return the current instance of <code>MessageDestinationType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllMessageDestination();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:webservice-descriptionType ElementType : webservice-description
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>webservice-description</code> element will be created and returned.
    * Otherwise, the first existing <code>webservice-description</code> element will be returned.
    * @return the instance defined for the element <code>webservice-description</code> 
    */
   public WebserviceDescriptionType<JbossWebDescriptor> getOrCreateWebserviceDescription();

   /**
    * Creates a new <code>webservice-description</code> element 
    * @return the new created instance of <code>WebserviceDescriptionType<JbossWebDescriptor></code> 
    */
   public WebserviceDescriptionType<JbossWebDescriptor> createWebserviceDescription();

   /**
    * Returns all <code>webservice-description</code> elements
    * @return list of <code>webservice-description</code> 
    */
   public List<WebserviceDescriptionType<JbossWebDescriptor>> getAllWebserviceDescription();

   /**
    * Removes all <code>webservice-description</code> elements 
    * @return the current instance of <code>WebserviceDescriptionType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllWebserviceDescription();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: xsd:token ElementType : depends
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Creates for all String objects representing <code>depends</code> elements, 
    * a new <code>depends</code> element 
    * @param values list of <code>depends</code> objects 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor depends(String ... values);

   /**
    * Returns all <code>depends</code> elements
    * @return list of <code>depends</code> 
    */
   public List<String> getAllDepends();

   /**
    * Removes the <code>depends</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeAllDepends();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:servletType ElementType : servlet
   // MaxOccurs: -unbounded  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>servlet</code> element will be created and returned.
    * Otherwise, the first existing <code>servlet</code> element will be returned.
    * @return the instance defined for the element <code>servlet</code> 
    */
   public ServletType<JbossWebDescriptor> getOrCreateServlet();

   /**
    * Creates a new <code>servlet</code> element 
    * @return the new created instance of <code>ServletType<JbossWebDescriptor></code> 
    */
   public ServletType<JbossWebDescriptor> createServlet();

   /**
    * Returns all <code>servlet</code> elements
    * @return list of <code>servlet</code> 
    */
   public List<ServletType<JbossWebDescriptor>> getAllServlet();

   /**
    * Removes all <code>servlet</code> elements 
    * @return the current instance of <code>ServletType<JbossWebDescriptor></code> 
    */
   public JbossWebDescriptor removeAllServlet();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: xsd:integer ElementType : max-active-sessions
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>max-active-sessions</code> element
    * @param maxActiveSessions the value for the element <code>max-active-sessions</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor maxActiveSessions(Integer maxActiveSessions);

   /**
    * Returns the <code>max-active-sessions</code> element
    * @return the node defined for the element <code>max-active-sessions</code> 
    */
   public Integer getMaxActiveSessions();

   /**
    * Removes the <code>max-active-sessions</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeMaxActiveSessions();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:passivation-configType ElementType : passivation-config
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>passivation-config</code> element with the given value will be created.
    * Otherwise, the existing <code>passivation-config</code> element will be returned.
    * @return  a new or existing instance of <code>PassivationConfigType<JbossWebDescriptor></code> 
    */
   public PassivationConfigType<JbossWebDescriptor> getOrCreatePassivationConfig();

   /**
    * Removes the <code>passivation-config</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removePassivationConfig();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:annotationType ElementType : annotation
   // MaxOccurs: -  isGeneric: false   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>annotation</code> element with the given value will be created.
    * Otherwise, the existing <code>annotation</code> element will be returned.
    * @return  a new or existing instance of <code>AnnotationType<JbossWebDescriptor></code> 
    */
   public AnnotationType<JbossWebDescriptor> getOrCreateAnnotation();

   /**
    * Removes the <code>annotation</code> element 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeAnnotation();
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: JbossWebDescriptor ElementName: jboss:jboss-web-versionType ElementType : version
   // MaxOccurs: -  isGeneric: false   isAttribute: true isEnum: true isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor version(JbossWebVersionType version);

   /**
    * Sets the <code>version</code> attribute
    * @param version the value for the attribute <code>version</code> 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor version(String version);

   /**
    * Returns the <code>version</code> attribute
    * @return the value defined for the attribute <code>version</code> 
    */
public JbossWebVersionType getVersion();

   /**
    * Returns the <code>version</code> attribute
    * @return the value found for the element <code>version</code> 
    */
   public String  getVersionAsString();

   /**
    * Removes the <code>version</code> attribute 
    * @return the current instance of <code>JbossWebDescriptor</code> 
    */
   public JbossWebDescriptor removeVersion();
}
