package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigFileType;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigFileType;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.ConfigFileType;
/**
 * This interface defines the contract for the <code> config-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface ConfigType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigType ElementName: wildfly:config-file-type ElementType : standalone
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>standalone</code> element will be created and returned.
    * Otherwise, the first existing <code>standalone</code> element will be returned.
    * @return the instance defined for the element <code>standalone</code> 
    */
   public ConfigFileType<ConfigType<T>> getOrCreateStandalone();

   /**
    * Creates a new <code>standalone</code> element 
    * @return the new created instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigFileType<ConfigType<T>> createStandalone();

   /**
    * Returns all <code>standalone</code> elements
    * @return list of <code>standalone</code> 
    */
   public List<ConfigFileType<ConfigType<T>>> getAllStandalone();

   /**
    * Removes all <code>standalone</code> elements 
    * @return the current instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigType<T> removeAllStandalone();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigType ElementName: wildfly:config-file-type ElementType : domain
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>domain</code> element will be created and returned.
    * Otherwise, the first existing <code>domain</code> element will be returned.
    * @return the instance defined for the element <code>domain</code> 
    */
   public ConfigFileType<ConfigType<T>> getOrCreateDomain();

   /**
    * Creates a new <code>domain</code> element 
    * @return the new created instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigFileType<ConfigType<T>> createDomain();

   /**
    * Returns all <code>domain</code> elements
    * @return list of <code>domain</code> 
    */
   public List<ConfigFileType<ConfigType<T>>> getAllDomain();

   /**
    * Removes all <code>domain</code> elements 
    * @return the current instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigType<T> removeAllDomain();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConfigType ElementName: wildfly:config-file-type ElementType : host
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>host</code> element will be created and returned.
    * Otherwise, the first existing <code>host</code> element will be returned.
    * @return the instance defined for the element <code>host</code> 
    */
   public ConfigFileType<ConfigType<T>> getOrCreateHost();

   /**
    * Creates a new <code>host</code> element 
    * @return the new created instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigFileType<ConfigType<T>> createHost();

   /**
    * Returns all <code>host</code> elements
    * @return list of <code>host</code> 
    */
   public List<ConfigFileType<ConfigType<T>>> getAllHost();

   /**
    * Removes all <code>host</code> elements 
    * @return the current instance of <code>ConfigFileType<ConfigType<T>></code> 
    */
   public ConfigType<T> removeAllHost();
}
