package org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.wildflyfeaturepack11.NamedType;
/**
 * This interface defines the contract for the <code> dependencies-type </code> xsd type 
 * @author <a href="mailto:bmcwhirt@redhat.com">Bob McWhirter</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public interface DependenciesType<T> extends Child<T> { 

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: DependenciesType ElementName: wildfly:named-type ElementType : artifact
   // MaxOccurs: -unbounded  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>artifact</code> element will be created and returned.
    * Otherwise, the first existing <code>artifact</code> element will be returned.
    * @return the instance defined for the element <code>artifact</code> 
    */
   public NamedType<DependenciesType<T>> getOrCreateArtifact();

   /**
    * Creates a new <code>artifact</code> element 
    * @return the new created instance of <code>NamedType<DependenciesType<T>></code> 
    */
   public NamedType<DependenciesType<T>> createArtifact();

   /**
    * Returns all <code>artifact</code> elements
    * @return list of <code>artifact</code> 
    */
   public List<NamedType<DependenciesType<T>>> getAllArtifact();

   /**
    * Removes all <code>artifact</code> elements 
    * @return the current instance of <code>NamedType<DependenciesType<T>></code> 
    */
   public DependenciesType<T> removeAllArtifact();
}
