package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment11; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ModuleType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ModuleAliasType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment11.ModuleAliasTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment11.FilterTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.DependenciesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment11.DependenciesTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment11.ResourcesType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment11.ResourcesTypeImpl;

/**
 * This class implements the <code> moduleType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class ModuleTypeImpl<T> implements Child<T>, ModuleType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public ModuleTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public ModuleTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:moduleAliasType ElementType : module-alias
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>module-alias</code> element with the given value will be created.
    * Otherwise, the existing <code>module-alias</code> element will be returned.
    * @return  a new or existing instance of <code>ModuleAliasType<ModuleType<T>></code> 
    */
   public ModuleAliasType<ModuleType<T>> getOrCreateModuleAlias()
   {
      Node node = childNode.getOrCreate("module-alias");
      ModuleAliasType<ModuleType<T>> moduleAlias = new ModuleAliasTypeImpl<ModuleType<T>>(this, "module-alias", childNode, node);
      return moduleAlias;
   }

   /**
    * Removes the <code>module-alias</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeModuleAlias()
   {
      childNode.removeChildren("module-alias");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<ModuleType<T>></code> 
    */
   public FilterType<ModuleType<T>> getOrCreateExports()
   {
      Node node = childNode.getOrCreate("exports");
      FilterType<ModuleType<T>> exports = new FilterTypeImpl<ModuleType<T>>(this, "exports", childNode, node);
      return exports;
   }

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeExports()
   {
      childNode.removeChildren("exports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:dependenciesType ElementType : dependencies
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>dependencies</code> element with the given value will be created.
    * Otherwise, the existing <code>dependencies</code> element will be returned.
    * @return  a new or existing instance of <code>DependenciesType<ModuleType<T>></code> 
    */
   public DependenciesType<ModuleType<T>> getOrCreateDependencies()
   {
      Node node = childNode.getOrCreate("dependencies");
      DependenciesType<ModuleType<T>> dependencies = new DependenciesTypeImpl<ModuleType<T>>(this, "dependencies", childNode, node);
      return dependencies;
   }

   /**
    * Removes the <code>dependencies</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeDependencies()
   {
      childNode.removeChildren("dependencies");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: jboss:resourcesType ElementType : resources
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>resources</code> element with the given value will be created.
    * Otherwise, the existing <code>resources</code> element will be returned.
    * @return  a new or existing instance of <code>ResourcesType<ModuleType<T>></code> 
    */
   public ResourcesType<ModuleType<T>> getOrCreateResources()
   {
      Node node = childNode.getOrCreate("resources");
      ResourcesType<ModuleType<T>> resources = new ResourcesTypeImpl<ModuleType<T>>(this, "resources", childNode, node);
      return resources;
   }

   /**
    * Removes the <code>resources</code> element 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeResources()
   {
      childNode.removeChildren("resources");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: xsd:string ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> name(String name)
   {
      childNode.attribute("name", name);
      return this;
   }

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
      public String getName()
   {
      return childNode.getAttribute("name");
   }

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeName()
   {
      childNode.removeAttribute("name");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ModuleType ElementName: xsd:string ElementType : slot
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>slot</code> attribute
    * @param slot the value for the attribute <code>slot</code> 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> slot(String slot)
   {
      childNode.attribute("slot", slot);
      return this;
   }

   /**
    * Returns the <code>slot</code> attribute
    * @return the value defined for the attribute <code>slot</code> 
    */
      public String getSlot()
   {
      return childNode.getAttribute("slot");
   }

   /**
    * Removes the <code>slot</code> attribute 
    * @return the current instance of <code>ModuleType<T></code> 
    */
   public ModuleType<T> removeSlot()
   {
      childNode.removeAttribute("slot");
      return this;
   }
}
