package org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13; 

import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.SystemDependencyType;
import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.impl.base.XMLDate;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.api.DescriptorExporter;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.PathSetType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.PathSetTypeImpl;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.FilterType;
import org.jboss.shrinkwrap.descriptor.impl.jbossdeployment13.FilterTypeImpl;

/**
 * This class implements the <code> systemDependencyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 */
public class SystemDependencyTypeImpl<T> implements Child<T>, SystemDependencyType<T>
{
   // -------------------------------------------------------------------------------------||
   // Instance Members 
   // -------------------------------------------------------------------------------------||

   private T t;
   private Node childNode;
   // -------------------------------------------------------------------------------------||
   // Constructor 
   // -------------------------------------------------------------------------------------||

   public SystemDependencyTypeImpl(T t, String nodeName, Node node)   {
      this.t = t;
      this.childNode = node.createChild(nodeName);
   }

   public SystemDependencyTypeImpl(T t, String nodeName, Node node, Node childNode)   {
      this.t = t;
      this.childNode = childNode;
   }


   public T up()
   {
      return t;
   }


 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SystemDependencyType ElementName: jboss:pathSetType ElementType : paths
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>paths</code> element with the given value will be created.
    * Otherwise, the existing <code>paths</code> element will be returned.
    * @return  a new or existing instance of <code>PathSetType<SystemDependencyType<T>></code> 
    */
   public PathSetType<SystemDependencyType<T>> getOrCreatePaths()
   {
      Node node = childNode.getOrCreate("paths");
      PathSetType<SystemDependencyType<T>> paths = new PathSetTypeImpl<SystemDependencyType<T>>(this, "paths", childNode, node);
      return paths;
   }

   /**
    * Removes the <code>paths</code> element 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> removePaths()
   {
      childNode.removeChildren("paths");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SystemDependencyType ElementName: jboss:filterType ElementType : exports
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * If not already created, a new <code>exports</code> element with the given value will be created.
    * Otherwise, the existing <code>exports</code> element will be returned.
    * @return  a new or existing instance of <code>FilterType<SystemDependencyType<T>></code> 
    */
   public FilterType<SystemDependencyType<T>> getOrCreateExports()
   {
      Node node = childNode.getOrCreate("exports");
      FilterType<SystemDependencyType<T>> exports = new FilterTypeImpl<SystemDependencyType<T>>(this, "exports", childNode, node);
      return exports;
   }

   /**
    * Removes the <code>exports</code> element 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> removeExports()
   {
      childNode.removeChildren("exports");
      return this;
   }

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: SystemDependencyType ElementName: xsd:boolean ElementType : export
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>export</code> attribute
    * @param export the value for the attribute <code>export</code> 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> export(Boolean export)
   {
      childNode.attribute("export", export);
      return this;
   }

   /**
    * Returns the <code>export</code> attribute
    * @return the value defined for the attribute <code>export</code> 
    */
   public Boolean isExport()
   {
      return Strings.isTrue(childNode.getAttribute("export"));
   }

   /**
    * Removes the <code>export</code> attribute 
    * @return the current instance of <code>SystemDependencyType<T></code> 
    */
   public SystemDependencyType<T> removeExport()
   {
      childNode.removeAttribute("export");
      return this;
   }
}
