/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package javax.management.j2ee.statistics;

import javax.management.*;
import javax.management.j2ee.Management;
import javax.ejb.EJBObject;
import javax.ejb.EJBHome;
import javax.ejb.CreateException;
import java.rmi.RemoteException;
import java.util.Set;

/**
 * Specifies the statistics provided by a JMS connection
 * 
 * @author thomas.diesler@jboss.org
 */
public interface JMSConnectionStats  extends Stats
{
   /**
    * Returns an array of JMSSessionStats that provide statistics about the sessions associated with the referencing JMSConnectionStats.
    */
   public JMSSessionStats[] getSessions();

   /**
    * Returns the transactional state of this JMS connection. If true, indicates that this JMS connection is transactional.
    */
   public boolean isTransactional();
}

