/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.bootstrap.modules.BootModuleLoader;
import org.wildfly.swarm.bootstrap.util.Layout;
import org.wildfly.swarm.bootstrap.util.UberJarManifest;

public class Main {
    public static final String DEFAULT_MAIN_CLASS_NAME = "org.wildfly.swarm.Swarm";
    private final String[] args;

    public static void main(String ... args) throws Throwable {
        new Main(args).run();
    }

    public Main(String ... args) throws Throwable {
        this.args = args;
    }

    public void run() throws Throwable {
        this.setupBootModuleLoader();
        this.invoke(this.getMainClass());
    }

    public void setupBootModuleLoader() {
        System.setProperty("boot.module.loader", BootModuleLoader.class.getName());
    }

    public String getMainClassName() throws IOException, URISyntaxException {
        String mainClassName = null;
        UberJarManifest manifest = new UberJarManifest(Layout.getInstance().getManifest());
        mainClassName = manifest.getMainClassName();
        if (mainClassName == null) {
            mainClassName = DEFAULT_MAIN_CLASS_NAME;
        }
        return mainClassName;
    }

    public Class<?> getMainClass() throws IOException, URISyntaxException, ModuleLoadException, ClassNotFoundException {
        String mainClassName = this.getMainClassName();
        Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create("swarm.application"));
        return module.getClassLoader().loadClass(mainClassName);
    }

    public void invoke(Class<?> mainClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method mainMethod = mainClass.getMethod("main", String[].class);
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            throw new NoSuchMethodException("Main method is not static for " + mainClass);
        }
        mainMethod.invoke(null, new Object[]{this.args});
    }
}

