/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.modules.maven.MavenResolver;

public class UberJarMavenResolver
implements MavenResolver {
    private static final Pattern snapshotPattern = Pattern.compile("-\\d{8}\\.\\d{6}-\\d+$");

    @Override
    public File resolveArtifact(ArtifactCoordinates coordinates, String packaging) throws IOException {
        String artifactRelativePath = "m2repo/" + UberJarMavenResolver.relativeArtifactPath('/', coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion());
        String classifier = "";
        if (coordinates.getClassifier() != null && !coordinates.getClassifier().trim().isEmpty()) {
            classifier = "-" + coordinates.getClassifier();
        }
        String jarPath = artifactRelativePath + classifier + "." + packaging;
        InputStream stream = UberJarMavenResolver.class.getClassLoader().getResourceAsStream(jarPath);
        if (stream != null) {
            return UberJarMavenResolver.copyTempJar(coordinates.getArtifactId() + "-" + coordinates.getVersion(), stream, packaging);
        }
        return null;
    }

    public static File copyTempJar(String artifactId, InputStream in, String packaging) throws IOException {
        Path tmp = Files.createTempFile(artifactId, "." + packaging, new FileAttribute[0]);
        Files.copy(in, tmp, StandardCopyOption.REPLACE_EXISTING);
        return tmp.toFile();
    }

    static String relativeArtifactPath(char separator, String groupId, String artifactId, String version) {
        StringBuilder builder = new StringBuilder(groupId.replace('.', separator));
        builder.append(separator).append(artifactId).append(separator);
        Matcher versionMatcher = snapshotPattern.matcher(version);
        String pathVersion = versionMatcher.find() ? version.substring(0, versionMatcher.start()) + "-SNAPSHOT" : version;
        builder.append(pathVersion).append(separator).append(artifactId).append('-').append(version);
        return builder.toString();
    }
}

