/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;

public class Layout {
    private static Layout INSTANCE;
    private final Path root;
    private boolean uberJar;
    private boolean unpackedUberJar;
    private ClassLoader bootstrapClassLoader;

    public static Layout getInstance() throws IOException, URISyntaxException {
        if (INSTANCE == null) {
            INSTANCE = new Layout(Layout.class.getProtectionDomain().getCodeSource());
        }
        return INSTANCE;
    }

    Layout(CodeSource codeSource) throws IOException, URISyntaxException {
        this.root = this.determineRoot(codeSource);
        this.determineIfIsUberJar();
    }

    public Path getRoot() {
        return this.root;
    }

    public boolean isUberJar() {
        return this.uberJar;
    }

    public Manifest getManifest() throws IOException {
        Path root = this.getRoot();
        String mfName = "META-INF/MANIFEST.MF";
        if (this.isUberJar()) {
            if (this.isUnpackedUberJar()) {
                Path mani = root.resolve(mfName);
                FileInputStream in = new FileInputStream(mani.toFile());
                return new Manifest(in);
            }
            try (JarFile jar = new JarFile(root.toFile());){
                ZipEntry entry = jar.getEntry(mfName);
                if (entry != null) {
                    InputStream in = jar.getInputStream(entry);
                    Manifest manifest = new Manifest(in);
                    return manifest;
                }
            }
        }
        return null;
    }

    private boolean isUnpackedUberJar() {
        return this.unpackedUberJar;
    }

    public synchronized ClassLoader getBootstrapClassLoader() throws ModuleLoadException {
        if (this.bootstrapClassLoader == null) {
            this.bootstrapClassLoader = this.determineBootstrapClassLoader();
        }
        return this.bootstrapClassLoader;
    }

    private Path determineRoot(CodeSource codeSource) throws IOException, URISyntaxException {
        URL location = codeSource.getLocation();
        if (location.getProtocol().equals("file")) {
            return Paths.get(location.toURI());
        }
        throw new IOException("Unable to determine root");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determineIfIsUberJar() throws IOException {
        Path root = this.getRoot();
        String wfsprops = "META-INF/wildfly-swarm.properties";
        if (Files.isRegularFile(root, new LinkOption[0])) {
            try (JarFile jar = new JarFile(root.toFile());){
                ZipEntry propsEntry = jar.getEntry(wfsprops);
                if (propsEntry == null) return;
                InputStream in = jar.getInputStream(propsEntry);
                this.setupProperties(in);
                this.uberJar = true;
                this.unpackedUberJar = false;
                return;
            }
        } else {
            Path props = root.resolve(wfsprops);
            if (!Files.exists(props, new LinkOption[0])) return;
            FileInputStream in = new FileInputStream(props.toFile());
            this.setupProperties(in);
            this.uberJar = true;
            this.unpackedUberJar = true;
        }
    }

    private void setupProperties(InputStream inps) throws IOException {
        try (InputStream in = inps;){
            Properties props = new Properties();
            props.load(in);
            if (props.containsKey("wildfly.swarm.app.artifact")) {
                System.setProperty("wildfly.swarm.app.artifact", props.getProperty("wildfly.swarm.app.artifact"));
            }
            Set<String> names = props.stringPropertyNames();
            for (String name : names) {
                String value = props.getProperty(name);
                if (System.getProperty(name) != null) continue;
                System.setProperty(name, value);
            }
        }
    }

    private ClassLoader determineBootstrapClassLoader() throws ModuleLoadException {
        try {
            return Module.getBootModuleLoader().loadModule(ModuleIdentifier.create("org.wildfly.swarm.bootstrap")).getClassLoader();
        }
        catch (ModuleLoadException e) {
            return Layout.class.getClassLoader();
        }
    }
}

