/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.logging;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.swarm.bootstrap.logging.BackingLogger;
import org.wildfly.swarm.bootstrap.logging.BackingLoggerManager;
import org.wildfly.swarm.bootstrap.logging.InitialLoggerManager;

public class BootstrapLogger {
    private static Map<String, BootstrapLogger> LOGGERS = new HashMap<String, BootstrapLogger>();
    private static BackingLoggerManager MANAGER = InitialLoggerManager.INSTANCE;
    private static Object LOCK = new Object();
    private final String name;
    private BackingLogger backingLogger;

    private BootstrapLogger(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BootstrapLogger logger(String name) {
        Map<String, BootstrapLogger> map = LOGGERS;
        synchronized (map) {
            BootstrapLogger logger = LOGGERS.get(name);
            if (logger == null) {
                logger = new BootstrapLogger(name);
                LOGGERS.put(name, logger);
            }
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBackingLoggerManager(BackingLoggerManager manager) {
        Object object = LOCK;
        synchronized (object) {
            MANAGER = manager;
            LOGGERS.values().forEach(BootstrapLogger::resetBackingLogger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackingLogger getBackingLogger() {
        if (this.backingLogger == null) {
            Object object = LOCK;
            synchronized (object) {
                this.backingLogger = MANAGER.getBackingLogger(this.name);
            }
        }
        return this.backingLogger;
    }

    void resetBackingLogger() {
        this.backingLogger = null;
    }

    public void trace(Object message) {
        this.getBackingLogger().trace(message);
    }

    public void debug(Object message) {
        this.getBackingLogger().debug(message);
    }

    public void info(Object message) {
        this.getBackingLogger().info(message);
    }

    public void warn(Object message) {
        this.getBackingLogger().warn(message);
    }

    public void error(Object message) {
        this.getBackingLogger().error(message);
    }

    public void error(Object message, Throwable t) {
        this.getBackingLogger().error(message, t);
    }

    public Object getLevel() {
        return this.getBackingLogger().getLevel();
    }

    public boolean isDebugEnabled() {
        return this.getBackingLogger().isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.getBackingLogger().isTraceEnabled();
    }

    public String toString() {
        return "[" + this.name + ": " + this.getLevel() + "]";
    }

    public static enum Level {
        NONE(java.util.logging.Level.OFF),
        ERROR(java.util.logging.Level.SEVERE),
        WARN(java.util.logging.Level.WARNING),
        INFO(java.util.logging.Level.INFO),
        DEBUG(java.util.logging.Level.FINER),
        TRACE(java.util.logging.Level.FINEST),
        ALL(java.util.logging.Level.ALL);

        private final java.util.logging.Level jul;

        private Level(java.util.logging.Level jul) {
            this.jul = jul;
        }

        public java.util.logging.Level toJUL() {
            return this.jul;
        }
    }
}

