/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class WildFlySwarmClasspathConf {
    public static final String CLASSPATH_LOCATION = "META-INF/wildfly-swarm-classpath.conf";
    private List<Matcher> matchers = new ArrayList<Matcher>();
    private static final String MAVEN_MATCHER_PREFIX = "maven(";
    private static final String PACKAGE_MATCHER_PREFIX = "package(";
    private static final String REPLACE_ACTION_PREFIX = "replace(";

    public WildFlySwarmClasspathConf() {
    }

    public WildFlySwarmClasspathConf(InputStream in) throws IOException {
        this.read(in);
    }

    public WildFlySwarmClasspathConf(ClassLoader classLoader) throws IOException {
        Enumeration<URL> classpathConfs = classLoader.getResources(CLASSPATH_LOCATION);
        while (classpathConfs.hasMoreElements()) {
            URL each = classpathConfs.nextElement();
            InputStream in = each.openStream();
            Throwable throwable = null;
            try {
                this.read(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    public Set<Action> getActions(JarFile jar) {
        return this.matchers.stream().filter(e -> e.matches(jar)).map(e -> e.getAction()).collect(Collectors.toSet());
    }

    public Set<Action> getActions(File file, String groupId, String artifactId) {
        Set<Action> actions = null;
        try (JarFile jar = new JarFile(file);){
            actions = this.getActions(jar);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        actions.addAll(this.getActions(groupId, artifactId));
        return actions;
    }

    public Set<Action> getActions(String groupId, String artifactId) {
        return this.matchers.stream().filter(e -> e.matches(groupId, artifactId)).map(Matcher::getAction).collect(Collectors.toSet());
    }

    public List<Matcher> getMatchesForActionType(Class<? extends Matcher> matcherType, Class<? extends Action> actionType) {
        return this.matchers.stream().filter(m -> m.getClass().isAssignableFrom(matcherType)).filter(m -> m.getAction().getClass().isAssignableFrom(actionType)).collect(Collectors.toList());
    }

    public void read(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                this.process(line);
            }
        }
    }

    List<Matcher> getMatchers() {
        return this.matchers;
    }

    void process(String line) {
        int spaceLoc = line.indexOf(32);
        if (spaceLoc < 0) {
            return;
        }
        String left = line.substring(0, spaceLoc);
        String right = line.substring(spaceLoc + 1);
        Matcher matcher = this.getMatcher(left);
        if (matcher == null) {
            System.err.println("problem parsing: " + line);
            return;
        }
        Action action = this.getAction(right);
        if (action == null) {
            System.err.println("problem parsing: " + line);
            return;
        }
        matcher.setAction(action);
        this.matchers.add(matcher);
    }

    Matcher getMatcher(String text) {
        if (text.startsWith(MAVEN_MATCHER_PREFIX)) {
            return this.getGAVMatcher(text);
        }
        if (text.startsWith(PACKAGE_MATCHER_PREFIX)) {
            return this.getPackageMatcher(text);
        }
        return null;
    }

    MavenMatcher getGAVMatcher(String text) {
        int rightParenLoc = text.indexOf(41);
        if (rightParenLoc < 0) {
            return null;
        }
        String gav = text.substring(MAVEN_MATCHER_PREFIX.length(), rightParenLoc);
        String[] parts = gav.split(":");
        return new MavenMatcher(parts[0], parts[1]);
    }

    PackageMatcher getPackageMatcher(String text) {
        int rightParenLoc = text.indexOf(41);
        if (rightParenLoc < 0) {
            return null;
        }
        String pkg = text.substring(PACKAGE_MATCHER_PREFIX.length(), rightParenLoc);
        return new PackageMatcher(pkg);
    }

    Action getAction(String text) {
        if ((text = text.trim()).equalsIgnoreCase("remove")) {
            return new RemoveAction();
        }
        if (text.startsWith(REPLACE_ACTION_PREFIX)) {
            int rightParenLoc = text.indexOf(41);
            if (rightParenLoc < 0) {
                return null;
            }
            String moduleSpec = text.substring(REPLACE_ACTION_PREFIX.length(), rightParenLoc);
            String[] parts = moduleSpec.split(":");
            String moduleName = parts[0];
            String moduleSlot = "main";
            if (parts.length > 1) {
                moduleSlot = parts[1];
            }
            return new ReplaceAction(moduleName, moduleSlot);
        }
        return null;
    }

    public class ReplaceAction
    implements Action {
        public final String moduleName;
        public final String moduleSlot;

        public ReplaceAction(String moduleName, String moduleSlot) {
            this.moduleName = moduleName;
            this.moduleSlot = moduleSlot;
        }
    }

    public class RemoveAction
    implements Action {
    }

    public static interface Action {
    }

    public static class PackageMatcher
    extends Matcher {
        public final String pkg;

        public PackageMatcher(String pkg) {
            this.pkg = pkg;
        }

        @Override
        boolean matches(JarFile file) {
            String pkgPath = this.pkg.replaceAll("\\.", "/");
            return file.getEntry(pkgPath) != null;
        }

        public String toString() {
            return WildFlySwarmClasspathConf.PACKAGE_MATCHER_PREFIX + this.pkg + ") " + this.getAction();
        }
    }

    public static class MavenMatcher
    extends Matcher {
        public final String groupId;
        public final String artifactId;

        public MavenMatcher(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        @Override
        public boolean matches(String groupId, String artifactId) {
            return groupId.equals(this.groupId) && artifactId.equals(this.artifactId);
        }

        public String toString() {
            return WildFlySwarmClasspathConf.MAVEN_MATCHER_PREFIX + this.groupId + ":" + this.artifactId + ") " + this.getAction();
        }
    }

    public static class Matcher {
        private Action action;

        void setAction(Action action) {
            this.action = action;
        }

        Action getAction() {
            return this.action;
        }

        boolean matches(JarFile file) {
            return false;
        }

        boolean matches(String groupId, String artifactId) {
            return false;
        }
    }
}

