/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.env.DependencyResolution;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;

public class MavenDependencyResolution
implements DependencyResolution {
    @Override
    public Set<String> resolve(List<String> exclusions) throws IOException {
        HashSet<String> archivePaths = new HashSet<String>();
        ApplicationEnvironment env = ApplicationEnvironment.get();
        env.getDependencies().forEach(dep -> {
            String[] parts = dep.split(":");
            ArtifactCoordinates coords = null;
            if (parts.length == 4) {
                coords = new ArtifactCoordinates(parts[0], parts[1], parts[3]);
            } else if (parts.length == 5) {
                coords = new ArtifactCoordinates(parts[0], parts[1], parts[3], parts[4]);
            }
            try {
                File artifact = MavenResolvers.get().resolveJarArtifact(coords);
                archivePaths.add(artifact.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return archivePaths;
    }
}

