/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaders;
import org.wildfly.swarm.bootstrap.util.TempFileManager;

public class NestedJarResourceLoader {
    private static Map<String, File> exploded = new HashMap<String, File>();

    public static ResourceLoader loaderFor(URL base, String rootPath, String loaderPath, String loaderName) throws IOException {
        String urlString = base.toExternalForm();
        if (urlString.startsWith("jar:file:")) {
            int endLoc = urlString.indexOf(".jar!");
            if (endLoc > 0) {
                String relativeRoot;
                File resourceRoot;
                String jarPath = urlString.substring(9, endLoc + 4);
                File exp = exploded.get(jarPath);
                if (exp == null) {
                    exp = TempFileManager.INSTANCE.newTempDirectory("module-jar", ".jar_d");
                    JarFile jarFile = new JarFile(jarPath);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry each = entries.nextElement();
                        if (each.isDirectory()) continue;
                        File out = new File(exp, each.getName());
                        out.getParentFile().mkdirs();
                        Files.copy(jarFile.getInputStream(each), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                if (!(resourceRoot = new File(new File(exp, relativeRoot = urlString.substring(endLoc + 5)), loaderPath)).isDirectory() && (resourceRoot.getName().endsWith(".jar") || resourceRoot.getName().endsWith(".war"))) {
                    JarFile jar = new JarFile(resourceRoot);
                    return ResourceLoaders.createJarResourceLoader(loaderName, jar);
                }
                return ResourceLoaders.createFileResourceLoader(loaderName, resourceRoot);
            }
        } else if (urlString.startsWith("file:")) {
            return ResourceLoaders.createFileResourceLoader(loaderPath, new File(urlString.substring(5, urlString.length())));
        }
        throw new IllegalArgumentException("Illegal module loader base: " + base);
    }
}

