/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.AbstractSingleModuleFinder;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.performance.Performance;

public class BootstrapModuleFinder
extends AbstractSingleModuleFinder {
    public static final String MODULE_NAME = "org.wildfly.swarm.bootstrap";
    private static final BootstrapLogger LOG = BootstrapLogger.logger("org.wildfly.swarm.modules.bootstrap");

    public BootstrapModuleFinder() {
        super(MODULE_NAME);
    }

    @Override
    public void buildModule(ModuleSpec.Builder builder, ModuleLoader delegateLoader) throws ModuleLoadException {
        try (AutoCloseable handle = Performance.accumulate("module: Bootstrap");){
            if (LOG.isTraceEnabled()) {
                LOG.trace("Loading module");
            }
            ApplicationEnvironment env = ApplicationEnvironment.get();
            env.bootstrapArtifacts().forEach(dep -> {
                String[] parts = dep.split(":");
                ArtifactCoordinates coords = null;
                if (parts.length == 4) {
                    coords = new ArtifactCoordinates(parts[0], parts[1], parts[3]);
                } else if (parts.length == 5) {
                    coords = new ArtifactCoordinates(parts[0], parts[1], parts[3], parts[4]);
                }
                try {
                    File artifact = MavenResolvers.get().resolveJarArtifact(coords);
                    if (artifact == null) {
                        throw new RuntimeException("Unable to resolve artifact from coordinates: " + coords);
                    }
                    JarFile jar = new JarFile(artifact);
                    ResourceLoader originaloader = ResourceLoaders.createJarResourceLoader(artifact.getName(), jar);
                    PathFilter filter = this.getModuleFilter(jar);
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createFilteredResourceLoader(filter, originaloader)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.modules")));
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.msc")));
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.jboss.shrinkwrap")));
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("javax.api")));
            builder.addDependency(DependencySpec.createModuleDependencySpec(ModuleIdentifier.create("org.yaml.snakeyaml")));
            HashSet<String> paths = new HashSet<String>();
            paths.add("org/wildfly/swarm/bootstrap/env");
            paths.add("org/wildfly/swarm/bootstrap/logging");
            paths.add("org/wildfly/swarm/bootstrap/modules");
            paths.add("org/wildfly/swarm/bootstrap/performance");
            paths.add("org/wildfly/swarm/bootstrap/util");
            builder.addDependency(DependencySpec.createSystemDependencySpec(paths, true));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PathFilter getModuleFilter(JarFile jar) {
        HashSet<String> paths = new HashSet<String>();
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            String name;
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory() || !(name = jarEntry.getName()).endsWith("/module.xml")) continue;
            paths.add(name);
        }
        return PathFilters.in(paths);
    }
}

