/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.wildfly.swarm.bootstrap.env.DependencyTree;
import org.wildfly.swarm.bootstrap.env.FractionManifest;
import org.wildfly.swarm.bootstrap.env.ManifestComparator;
import org.wildfly.swarm.bootstrap.env.MavenDependencyResolution;
import org.wildfly.swarm.bootstrap.env.SystemDependencyResolution;
import org.wildfly.swarm.bootstrap.env.WildFlySwarmManifest;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.performance.Performance;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.yaml.snakeyaml.Yaml;

public class ApplicationEnvironment {
    private Optional<DependencyTree<MavenArtifactDescriptor>> dependencyTree = Optional.empty();
    private Mode mode = Mode.CLASSPATH;
    private List<FractionManifest> manifests;
    private WildFlySwarmManifest applicationManifest;
    private List<String> bootstrapModules = new ArrayList<String>();
    private List<String> bootstrapArtifacts = new ArrayList<String>();
    private List<String> removeableDependencies = new ArrayList<String>();
    private static AtomicReference<ApplicationEnvironment> INSTANCE = new AtomicReference();
    public static final String DEFAULT_MAIN_CLASS_NAME = "org.wildfly.swarm.Swarm";

    public static ApplicationEnvironment get() {
        return INSTANCE.updateAndGet(env -> {
            if (env != null) {
                return env;
            }
            try (AutoCloseable handle = Performance.time("Load application environment");){
                ApplicationEnvironment applicationEnvironment = new ApplicationEnvironment();
                return applicationEnvironment;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private ApplicationEnvironment() {
        try {
            if (System.getProperty("swarm.isuberjar") != null) {
                this.mode = Mode.UBERJAR;
                if (!this.loadWildFlySwarmApplicationManifestFromClasspath()) {
                    this.loadWildFlySwarmApplicationManifestFromTCCL();
                }
            } else {
                this.mode = Mode.CLASSPATH;
                this.loadDependencyTree();
                this.loadFractionManifestsFromClasspath();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadDependencyTree() {
        String cpInfoProp = System.getProperty("swarm.cp.info");
        if (cpInfoProp == null) {
            return;
        }
        DependencyTree<MavenArtifactDescriptor> dependencyTree = new DependencyTree<MavenArtifactDescriptor>();
        Yaml yaml = new Yaml();
        try (FileInputStream fileStream = new FileInputStream(cpInfoProp);){
            Map data = yaml.loadAs(fileStream, Map.class);
            for (Map.Entry entry : data.entrySet()) {
                MavenArtifactDescriptor parent = MavenArtifactDescriptor.fromMavenGav((String)entry.getKey());
                Collection transientDeps = (Collection)entry.getValue();
                if (transientDeps != null && !transientDeps.isEmpty()) {
                    for (String transientDep : transientDeps) {
                        dependencyTree.add(parent, MavenArtifactDescriptor.fromMavenGav(transientDep));
                    }
                    continue;
                }
                dependencyTree.add(parent);
            }
            this.dependencyTree = Optional.of(dependencyTree);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load cp info", e);
        }
    }

    public List<String> bootstrapModules() {
        return this.bootstrapModules;
    }

    public List<String> bootstrapArtifacts() {
        return this.bootstrapArtifacts;
    }

    public List<ArtifactCoordinates> bootstrapArtifactsAsCoordinates() {
        return this.bootstrapArtifacts.stream().map(artifact -> {
            String[] parts = artifact.split(":");
            ArtifactCoordinates coords = null;
            if (parts.length == 4) {
                coords = new ArtifactCoordinates(parts[0], parts[1], parts[3]);
            } else if (parts.length == 5) {
                coords = new ArtifactCoordinates(parts[0], parts[1], parts[3], parts[4]);
            }
            return coords;
        }).collect(Collectors.toList());
    }

    public Mode getMode() {
        return this.mode;
    }

    private boolean loadWildFlySwarmApplicationManifestFromClasspath() throws IOException {
        return this.loadWildFlySwarmApplicationManifest(ClassLoader.getSystemClassLoader());
    }

    private boolean loadWildFlySwarmApplicationManifestFromTCCL() throws IOException {
        return this.loadWildFlySwarmApplicationManifest(Thread.currentThread().getContextClassLoader());
    }

    private boolean loadWildFlySwarmApplicationManifest(ClassLoader cl) throws IOException {
        URL url = cl.getResource("META-INF/wildfly-swarm-manifest.yaml");
        if (url == null) {
            return false;
        }
        this.applicationManifest = new WildFlySwarmManifest(url);
        this.bootstrapModules.addAll(this.applicationManifest.bootstrapModules());
        this.bootstrapArtifacts.addAll(this.applicationManifest.bootstrapArtifacts());
        return true;
    }

    private void loadFractionManifestsFromClasspath() throws IOException {
        this.loadFractionManifests(ClassLoader.getSystemClassLoader());
    }

    private void loadFractionManifestsFromUberjar() throws IOException, ModuleLoadException {
        if (this.manifests != null) {
            return;
        }
        this.manifests = new ArrayList<FractionManifest>();
        HashSet modulesManifests = new HashSet();
        this.bootstrapModules.forEach(moduleName -> {
            try {
                Module module = Module.getBootModuleLoader().loadModule((String)moduleName);
                ModuleClassLoader cl = module.getClassLoader();
                Enumeration<URL> results = ((ClassLoader)cl).getResources("META-INF/fraction-manifest.yaml");
                while (results.hasMoreElements()) {
                    URL each = results.nextElement();
                    FractionManifest manifest = new FractionManifest(each);
                    this.manifests.add(manifest);
                    modulesManifests.add(manifest.getGroupId() + manifest.getArtifactId());
                }
            }
            catch (IOException | ModuleLoadException e) {
                throw new RuntimeException(e);
            }
        });
        this.bootstrapArtifactsAsCoordinates().forEach(coords -> {
            try {
                File artifactFile = MavenResolvers.get().resolveJarArtifact((ArtifactCoordinates)coords);
                if (artifactFile == null) {
                    throw new RuntimeException("Unable to resolve artifact from coordinates: " + coords);
                }
                try (ZipFile zip = new ZipFile(artifactFile);){
                    FractionManifest manifest;
                    ZipEntry manifestEntry = zip.getEntry("META-INF/fraction-manifest.yaml");
                    if (manifestEntry != null && !modulesManifests.contains((manifest = new FractionManifest(zip.getInputStream(manifestEntry))).getGroupId() + manifest.getArtifactId())) {
                        this.manifests.add(manifest);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.manifests.sort(new ManifestComparator());
    }

    private void loadFractionManifests(ClassLoader cl) throws IOException {
        if (this.manifests != null) {
            return;
        }
        this.manifests = new ArrayList<FractionManifest>();
        Enumeration<URL> results = cl.getResources("META-INF/fraction-manifest.yaml");
        HashSet<MavenArtifactDescriptor> fractionDependencies = new HashSet<MavenArtifactDescriptor>();
        while (results.hasMoreElements()) {
            URL each = results.nextElement();
            FractionManifest manifest = new FractionManifest(each);
            this.manifests.add(manifest);
            if (manifest.getModule() != null) {
                this.bootstrapModules.add(manifest.getModule());
            }
            if (this.mode != Mode.CLASSPATH) continue;
            MavenArtifactDescriptor fraction = new MavenArtifactDescriptor(manifest.getGroupId(), manifest.getArtifactId(), manifest.getVersion());
            if (this.dependencyTree.isPresent()) {
                for (MavenArtifactDescriptor directDep : this.dependencyTree.get().getDirectDeps()) {
                    if (!fraction.equals(directDep)) continue;
                    fractionDependencies.add(directDep);
                }
            }
            this.removeableDependencies.add(fraction.mavenGav());
            this.removeableDependencies.addAll(manifest.getDependencies());
        }
        if (this.dependencyTree.isPresent()) {
            HashSet<MavenArtifactDescriptor> applicationDependencies = new HashSet<MavenArtifactDescriptor>();
            HashSet<MavenArtifactDescriptor> keep = new HashSet<MavenArtifactDescriptor>(this.dependencyTree.get().getDirectDeps());
            keep.removeAll(fractionDependencies);
            for (MavenArtifactDescriptor dep : keep) {
                applicationDependencies.add(dep);
                applicationDependencies.addAll(this.dependencyTree.get().getTransientDeps(dep));
            }
            this.removeableDependencies.removeAll(applicationDependencies);
        }
        this.manifests.sort(new ManifestComparator());
    }

    public Set<String> getDependencies() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.getDependencies();
        }
        return Collections.emptySet();
    }

    public List<String> getRemovableDependencies() {
        return this.removeableDependencies;
    }

    public Set<String> resolveDependencies(List<String> exclusions) throws IOException {
        if (this.mode == Mode.UBERJAR) {
            return new MavenDependencyResolution().resolve(exclusions);
        }
        return new SystemDependencyResolution().resolve(exclusions);
    }

    public String getAsset() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.getAsset();
        }
        return null;
    }

    public String getMainClassName() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.getMainClass();
        }
        return DEFAULT_MAIN_CLASS_NAME;
    }

    public boolean isHollow() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.isHollow();
        }
        return false;
    }

    private Path root() {
        URL location = ApplicationEnvironment.class.getProtectionDomain().getCodeSource().getLocation();
        if (location.getProtocol().equals("file")) {
            try {
                return Paths.get(location.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public ClassLoader getBootstrapClassLoader() throws ModuleLoadException {
        if (this.mode == Mode.UBERJAR) {
            try {
                Module module = Module.getBootModuleLoader().loadModule("org.wildfly.swarm.bootstrap");
                ModuleClassLoader cl = module.getClassLoader();
                return cl;
            }
            catch (ModuleLoadException moduleLoadException) {
                // empty catch block
            }
        }
        return ApplicationEnvironment.class.getClassLoader();
    }

    public List<FractionManifest> fractionManifests() {
        if (this.mode == Mode.UBERJAR && this.manifests == null) {
            try {
                this.loadFractionManifestsFromUberjar();
            }
            catch (IOException | ModuleLoadException e) {
                throw new RuntimeException(e);
            }
        }
        return this.manifests;
    }

    public static enum Mode {
        UBERJAR,
        CLASSPATH;

    }
}

