/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.camel.core.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.service.CamelContextRegistryService;
import org.wildfly.swarm.camel.core.CamelCoreFraction;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.runtime.AbstractServerConfiguration;

public class CamelCoreConfiguration
extends AbstractServerConfiguration<CamelCoreFraction> {
    public CamelCoreConfiguration() {
        super(CamelCoreFraction.class);
    }

    public CamelCoreFraction defaultFraction() {
        return new CamelCoreFraction();
    }

    public List<ModelNode> getList(CamelCoreFraction fraction) throws Exception {
        ModelNode node = new ModelNode();
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        node.get("address").set("extension", "org.wildfly.extension.camel");
        node.get("operation").set("add");
        list.add(node);
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"camel")});
        node = new ModelNode();
        node.get("address").set(address.toModelNode());
        node.get("operation").set("add");
        list.add(node);
        return list;
    }

    public List<ServiceActivator> getServiceActivators(final CamelCoreFraction fraction) {
        ArrayList<ServiceActivator> activators = new ArrayList<ServiceActivator>(super.getServiceActivators((Fraction)fraction));
        activators.add(new ServiceActivator(){

            public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
                BootstrapCamelContextService.addService(context.getServiceTarget(), fraction);
            }
        });
        return activators;
    }

    static class BootstrapCamelContextService
    extends AbstractService<Void> {
        static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"wildfly", "swarm", "camel", "bootstrap"});
        InjectedValue<CamelContextRegistryService.MutableCamelContextRegistry> injectedContextRegistry = new InjectedValue();
        List<CamelContext> systemContexts = new ArrayList<CamelContext>();
        CamelCoreFraction fraction;

        static ServiceController<Void> addService(ServiceTarget serviceTarget, CamelCoreFraction fraction) {
            BootstrapCamelContextService service = new BootstrapCamelContextService(fraction);
            ServiceName serviceName = SERVICE_NAME;
            ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
            builder.addDependency(CamelConstants.CAMEL_CONTEXT_REGISTRY_SERVICE_NAME, CamelContextRegistryService.MutableCamelContextRegistry.class, service.injectedContextRegistry);
            return builder.install();
        }

        BootstrapCamelContextService(CamelCoreFraction fraction) {
            this.fraction = fraction;
        }

        public void start(StartContext startContext) throws StartException {
            CamelContextRegistryService.MutableCamelContextRegistry contextRegistry = (CamelContextRegistryService.MutableCamelContextRegistry)this.injectedContextRegistry.getValue();
            ClassLoader classLoader = CamelContextRegistryService.MutableCamelContextRegistry.class.getClassLoader();
            try {
                for (RouteBuilder builder : this.fraction.getRouteBuilders()) {
                    ModelCamelContext camelctx = builder.getContext();
                    camelctx.setApplicationContextClassLoader(classLoader);
                    builder.addRoutesToCamelContext((CamelContext)camelctx);
                    contextRegistry.addCamelContext((CamelContext)camelctx);
                    this.systemContexts.add((CamelContext)camelctx);
                }
                for (CamelContext camelctx : this.systemContexts) {
                    camelctx.start();
                }
            }
            catch (Exception ex) {
                throw new StartException((Throwable)ex);
            }
        }

        public void stop(StopContext startContext) {
            CamelContextRegistryService.MutableCamelContextRegistry contextRegistry = (CamelContextRegistryService.MutableCamelContextRegistry)this.injectedContextRegistry.getValue();
            Collections.reverse(this.systemContexts);
            for (CamelContext camelctx : this.systemContexts) {
                try {
                    camelctx.stop();
                }
                catch (Exception ex) {
                    CamelCoreFraction.LOGGER.error("Cannot stop context: " + camelctx, (Throwable)ex);
                }
            }
            for (CamelContext camelctx : this.systemContexts) {
                contextRegistry.removeCamelContext(camelctx);
            }
        }
    }
}

