/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.camel.core.runtime;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.camel.core.CamelFraction;
import org.wildfly.swarm.spi.runtime.CustomMarshaller;

@ApplicationScoped
public class CamelMarshaller
implements CustomMarshaller {
    @Inject
    CamelFraction fraction;

    public void marshal(List<ModelNode> list) {
        PathAddress subsystem = PathAddress.pathAddress((String)"subsystem", (String)"camel");
        Map<String, String> contexts = this.fraction.contexts();
        for (String key : contexts.keySet()) {
            String path = contexts.get(key);
            try {
                String value = this.read(path);
                PathAddress context = subsystem.append("context", key);
                ModelNode node = new ModelNode();
                node.get("operation").set("add");
                node.get("address").set(context.toModelNode());
                node.get("value").set(value);
                list.add(node);
            }
            catch (IOException | ModuleLoadException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String read(String path) throws ModuleLoadException, IOException {
        Module app = Module.getBootModuleLoader().loadModule("swarm.application");
        StringBuilder str = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(app.getClassLoader().getResourceAsStream(path));){
            char[] chars = new char[1024];
            int numRead = 0;
            while ((numRead = in.read(chars)) >= 0) {
                str.append(chars, 0, numRead);
            }
        }
        return str.toString();
    }
}

