/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.camel.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;
import org.wildfly.swarm.spi.api.annotations.WildFlySubsystem;

@WildFlyExtension(module="org.wildfly.extension.camel")
@WildFlySubsystem(value="camel")
@Configurable(value="swarm.camel")
public final class CamelFraction
implements Fraction<CamelFraction> {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"org.wildfly.swarm.camel");
    private final Map<String, RouteBuilder> routeBuilders = new LinkedHashMap<String, RouteBuilder>();
    private Map<String, String> contexts = new HashMap<String, String>();

    public CamelFraction addRouteBuilder(RouteBuilder builder) {
        return this.addRouteBuilder(null, builder);
    }

    public CamelFraction addRouteBuilder(String name, RouteBuilder builder) {
        IllegalArgumentAssertion.assertNotNull((Object)builder, (String)"builder");
        this.routeBuilders.put(name, builder);
        return this;
    }

    public Map<String, RouteBuilder> getRouteBuilders() {
        return Collections.unmodifiableMap(this.routeBuilders);
    }

    public void context(String key, String path) {
        this.contexts.put(key, path);
    }

    public void contexts(Map<String, String> contexts) {
        this.contexts.clear();
        this.contexts.putAll(contexts);
    }

    public Map<String, String> contexts() {
        return this.contexts;
    }
}

