/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cassandra.runtime;

import javax.enterprise.context.ApplicationScoped;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.swarm.cassandra.CassandraFraction;
import org.wildfly.swarm.config.cassandradriver.Cassandra;
import org.wildfly.swarm.container.util.DriverModuleBuilder;
import org.wildfly.swarm.container.util.Messages;

@ApplicationScoped
public class CassandraDriverInfo
extends DriverModuleBuilder {
    public CassandraDriverInfo() {
        super("Cassandra", "com.datastax.driver.core.Cluster", new String[]{"com.codahale.metrics.Metric", "io.netty.buffer.PooledByteBufAllocator", "io.netty.channel.group.ChannelGroup", "io.netty.util.Timer", "io.netty.handler.codec.MessageToMessageDecoder", "io.netty.handler.timeout.IdleStateHandler", "org.slf4j.impl.StaticLoggerBinder", "org.slf4j.LoggerFactory", "com.datastax.driver.core.Cluster", "com.datastax.driver.core.Session", "com.datastax.driver.core.Message", "com.google.common.util.concurrent.AsyncFunction"}, new ModuleIdentifier[]{ModuleIdentifier.create((String)"javax.api"), ModuleIdentifier.create((String)"org.picketbox"), ModuleIdentifier.create((String)"sun.jdk"), ModuleIdentifier.create((String)"org.slf4j"), ModuleIdentifier.create((String)"javax.transaction.api")});
    }

    public boolean detect(CassandraFraction fraction) {
        if (0 == fraction.subresources().cassandras().size()) {
            return false;
        }
        String moduleName = ((Cassandra)fraction.subresources().cassandras().get(0)).module() != null ? ((Cassandra)fraction.subresources().cassandras().get(0)).module() : "com.datastax.cassandra.driver-core";
        fraction.subresources().cassandras().forEach(cassandra -> {
            if (cassandra.module() != null && !moduleName.equals(cassandra.module())) {
                throw Messages.MESSAGES.cannotAddReferenceToModule(cassandra.module(), moduleName);
            }
        });
        return super.detect(moduleName);
    }
}

