/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wildfly.swarm.cdi.ConfigValue;
import org.wildfly.swarm.cdi.Configured;
import org.wildfly.swarm.spi.api.StageConfig;

public class ConfigExtension
implements Extension {
    public <X> void processInjectionTarget(@Observes ProcessInjectionTarget<X> pit) {
        final InjectionTarget it = pit.getInjectionTarget();
        final HashMap<Field, String> configFieldKeys = new HashMap<Field, String>();
        AnnotatedType at = pit.getAnnotatedType();
        Annotation annotation = at.getAnnotation(Configured.class);
        if (annotation == null) {
            return;
        }
        for (AnnotatedField aField : at.getFields()) {
            if (!aField.isAnnotationPresent(ConfigValue.class)) continue;
            Field field = aField.getJavaMember();
            field.setAccessible(true);
            configFieldKeys.put(field, ((ConfigValue)aField.getAnnotation(ConfigValue.class)).value());
        }
        InjectionTarget wrapped = new InjectionTarget<X>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void inject(X instance, CreationalContext<X> ctx) {
                it.inject(instance, ctx);
                try {
                    StageConfig stageConfig = ConfigExtension.lookup();
                    for (Map.Entry fieldKey : configFieldKeys.entrySet()) {
                        try {
                            String key = (String)fieldKey.getValue();
                            Class<?> type = ((Field)fieldKey.getKey()).getType();
                            ((Field)fieldKey.getKey()).set(instance, stageConfig.resolve(key).as(type).getValue());
                        }
                        catch (Exception e) {
                            throw new InjectionException((Throwable)e);
                            return;
                        }
                    }
                }
                catch (NamingException e) {
                    throw new InjectionException((Throwable)e);
                }
            }

            public void postConstruct(X instance) {
                it.postConstruct(instance);
            }

            public void preDestroy(X instance) {
                it.dispose(instance);
            }

            public void dispose(X instance) {
                it.dispose(instance);
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return it.getInjectionPoints();
            }

            public X produce(CreationalContext<X> ctx) {
                return it.produce(ctx);
            }
        };
        pit.setInjectionTarget(wrapped);
    }

    static StageConfig lookup() throws NamingException {
        InitialContext context = new InitialContext();
        return (StageConfig)context.lookup("jboss/swarm/stage-config");
    }
}

