/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi;

import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wildfly.swarm.cdi.ConfigValue;
import org.wildfly.swarm.spi.api.StageConfig;

@ApplicationScoped
public class ConfigValueProducer {
    private StageConfig stageConfig;

    @PostConstruct
    void init() {
        this.stageConfig = this.lookup();
    }

    @ConfigValue
    @Dependent
    @Produces
    StageConfig.Resolver<String> produceResolver(InjectionPoint injectionPoint) {
        return this.resolver(injectionPoint);
    }

    @ConfigValue
    @Dependent
    @Produces
    String produceStringConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, String.class);
    }

    @ConfigValue
    @Dependent
    @Produces
    Integer produceIntegerConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Integer.class);
    }

    @ConfigValue
    @Dependent
    @Produces
    Boolean produceBooleanConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Boolean.class);
    }

    @ConfigValue
    @Dependent
    @Produces
    Long produceLongConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Long.class);
    }

    @ConfigValue
    @Dependent
    @Produces
    Float produceFloatConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Float.class);
    }

    @ConfigValue
    @Dependent
    @Produces
    Double produceDoubleConfigValue(InjectionPoint injectionPoint) {
        return this.resolve(injectionPoint, Double.class);
    }

    private <T> T resolve(InjectionPoint injectionPoint, Class<T> target) {
        StageConfig.Resolver<String> resolver = this.resolver(injectionPoint);
        return (T)(resolver != null ? resolver.as(target).getValue() : null);
    }

    private StageConfig.Resolver<String> resolver(InjectionPoint injectionPoint) {
        String name = this.getName(injectionPoint);
        if (name.isEmpty() || this.stageConfig == null) {
            return null;
        }
        return this.stageConfig.resolve(this.getName(injectionPoint));
    }

    private String getName(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(ConfigValue.class)) continue;
            return ((ConfigValue)qualifier).value();
        }
        return null;
    }

    private StageConfig lookup() {
        try {
            InitialContext context = new InitialContext();
            return (StageConfig)context.lookup("jboss/swarm/stage-config");
        }
        catch (NamingException e) {
            return null;
        }
    }
}

