/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.cdi.jaxrsapi.runtime;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.wildfly.swarm.client.jaxrs.ServiceClient;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.spi.api.ArchiveMetadataProcessor;

@ApplicationScoped
public class ServiceClientProcessor
implements ArchiveMetadataProcessor {
    public void processArchive(Archive<?> archive, Index index) {
        List serviceClients = index.getKnownDirectImplementors(DotName.createSimple((String)ServiceClient.class.getName()));
        serviceClients.forEach(info -> {
            String name = info.name().toString() + "_generated";
            String path = "WEB-INF/classes/" + name.replace('.', '/') + ".class";
            ((JAXRSArchive)archive.as(JAXRSArchive.class)).add((Asset)new ByteArrayAsset(ClientServiceFactory.createImpl(name, info)), path);
        });
    }

    private static class ClientServiceFactory
    implements Opcodes {
        private ClientServiceFactory() {
        }

        static byte[] createImpl(String implName, ClassInfo classInfo) {
            ClassWriter cw = new ClassWriter(0);
            cw.visit(52, 33, implName.replace('.', '/'), null, "java/lang/Object", new String[]{classInfo.name().toString().replace('.', '/')});
            int lastDot = implName.lastIndexOf(46);
            String simpleName = implName.substring(lastDot + 1);
            cw.visitSource(simpleName + ".java", null);
            AnnotationVisitor av0 = cw.visitAnnotation("Ljavax/enterprise/context/ApplicationScoped;", true);
            av0.visitEnd();
            cw.visitInnerClass("javax/ws/rs/client/Invocation$Builder", "javax/ws/rs/client/Invocation", "Builder", 1545);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(14, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(15, l1);
            mv.visitInsn(177);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLocalVariable("this", ClientServiceFactory.buildTypeDef(implName), null, l0, l2, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            List annotations = (List)classInfo.annotations().get(DotName.createSimple((String)"org.wildfly.swarm.client.jaxrs.Service"));
            String baseUrl = (String)((AnnotationInstance)annotations.get(0)).value("baseUrl").value();
            int lineNum = 18;
            classInfo.asClass().methods().stream().forEachOrdered(method -> ClientServiceFactory.createMethod(cw, implName, classInfo.name().toString(), method, lineNum, baseUrl));
            cw.visitEnd();
            return cw.toByteArray();
        }

        static void createMethod(ClassWriter cw, String implName, String clientInterfaceName, MethodInfo method, int lineNum, String baseUrl) {
            MethodVisitor mv = cw.visitMethod(1, method.name(), ClientServiceFactory.buildMethodDef(method), null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(lineNum++, l0);
            mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType((String)ClientServiceFactory.buildTypeDef(clientInterfaceName)));
            mv.visitTypeInsn(187, "org/jboss/resteasy/client/jaxrs/ResteasyClientBuilder");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "org/jboss/resteasy/client/jaxrs/ResteasyClientBuilder", "<init>", "()V", false);
            mv.visitMethodInsn(182, "org/jboss/resteasy/client/jaxrs/ResteasyClientBuilder", "build", "()Lorg/jboss/resteasy/client/jaxrs/ResteasyClient;", false);
            mv.visitLdcInsn((Object)baseUrl);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(lineNum++, l1);
            mv.visitMethodInsn(182, "org/jboss/resteasy/client/jaxrs/ResteasyClient", "target", "(Ljava/lang/String;)Lorg/jboss/resteasy/client/jaxrs/ResteasyWebTarget;", false);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLineNumber(lineNum - 2, l2);
            mv.visitMethodInsn(184, "org/wildfly/swarm/cdi/jaxrsapi/deployment/ProxyBuilder", "builder", "(Ljava/lang/Class;Ljavax/ws/rs/client/WebTarget;)Lorg/wildfly/swarm/cdi/jaxrsapi/deployment/ProxyBuilder;", false);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLineNumber(lineNum++, l3);
            mv.visitMethodInsn(182, "org/wildfly/swarm/cdi/jaxrsapi/deployment/ProxyBuilder", "build", "()Ljava/lang/Object;", false);
            mv.visitTypeInsn(192, clientInterfaceName.replace('.', '/'));
            for (int i = 1; i <= method.parameters().size(); ++i) {
                mv.visitVarInsn(25, i);
            }
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitLineNumber(lineNum++, l4);
            mv.visitMethodInsn(185, clientInterfaceName.replace('.', '/'), method.name(), ClientServiceFactory.buildMethodDef(method), true);
            Label l5 = new Label();
            mv.visitLabel(l5);
            if (method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                mv.visitLineNumber(lineNum++, l5);
                mv.visitInsn(177);
            } else {
                mv.visitLineNumber(lineNum - 4, l5);
                mv.visitInsn(176);
            }
            Label l6 = new Label();
            mv.visitLabel(l6);
            int methodParams = 0;
            mv.visitLocalVariable("this", ClientServiceFactory.buildTypeDef(implName), null, l0, l6, methodParams++);
            for (AnnotationInstance anno : method.annotations()) {
                if (!anno.name().toString().contains("QueryParam") && !anno.name().toString().contains("PathParam")) continue;
                short position = anno.target().asMethodParameter().position();
                Type parameterType = (Type)anno.target().asMethodParameter().method().parameters().get(position);
                mv.visitLocalVariable(String.valueOf(anno.value().value()), ClientServiceFactory.buildTypeDef(parameterType.name().toString()), null, l0, l6, methodParams++);
            }
            mv.visitMaxs(3, methodParams);
            lineNum += 4;
            mv.visitEnd();
        }

        static String buildTypeDef(String name) {
            return "L" + name.replace('.', '/') + ";";
        }

        static String buildMethodDef(MethodInfo method) {
            StringBuilder builder = new StringBuilder();
            builder.append("(");
            for (Type type : method.parameters()) {
                builder.append(ClientServiceFactory.buildTypeDef(type.name().toString()));
            }
            builder.append(")");
            if (method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                builder.append("V");
            } else {
                builder.append(ClientServiceFactory.buildTypeDef(method.returnType().name().toString()));
            }
            return builder.toString();
        }
    }
}

